% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmt.R
\name{pmt}
\alias{pmt}
\alias{pmts}
\alias{define_pmt}
\title{Syntactic Sugar for Object Construction}
\usage{
pmt(key, ...)

pmts(
  which = c("all", "onesample", "twosample", "ksample", "multcomp", "paired", "rcbd",
    "association", "table")
)

define_pmt(
  statistic,
  inherit = c("twosample", "ksample", "paired", "rcbd", "association", "table"),
  rejection = c("lr", "l", "r"),
  scoring = c("none", "rank", "vw", "expon"),
  n_permu = 10000,
  name = "User-Defined Permutation Test",
  alternative = NULL,
  depends = character(),
  plugins = character(),
  includes = character()
)
}
\arguments{
\item{key}{a character string specifying the test. Check \code{pmts()} for valid keys.}

\item{...}{extra parameters passed to the constructor.}

\item{which}{a character string specifying the desired tests.}

\item{statistic}{definition of the test statistic. See Details.}

\item{inherit}{a character string specifying the desired permutation test.}

\item{rejection}{a character string specifying where the rejection region is.}

\item{scoring, n_permu}{passed to the constructor.}

\item{name}{a character string specifying the name of the test.}

\item{alternative}{a character string specifying the alternative of the test.}

\item{depends, plugins, includes}{passed to \code{\link[Rcpp:cppFunction]{Rcpp::cppFunction()}}.}
}
\value{
a test object corresponding to the specified key.

a data frame containing keys and corresponding tests implemented in this package.
}
\description{
Construct test objects in a unified way.
}
\details{
The test statistic in \code{define_pmt} can be defined using either \code{R} or \code{Rcpp}, with the \code{statistic} parameter specified as:
\itemize{
\item \code{R}: a function returning a closure that returns a double.
\item \code{Rcpp}: a character string defining a captureless lambda (introduced in C++11) returning another lambda that may capture by value, accepts const arguments of the same type, and returns a double.
}

When using \code{Rcpp}, the parameters for different \code{inherit} are listed as follows. Note that the parameter names are illustrative and may be modified.
\itemize{
\item \code{"twosample"}: \verb{(Rcpp::NumericVector sample_1, Rcpp::NumericVector sample_2)}
\item \code{"ksample"}: \verb{(Rcpp::NumericVector combined_sample, Rcpp::IntegerVector one_based_group_index)}
\item \code{"paired"}: \verb{(Rcpp::NumericVector sample_1, Rcpp::NumericVector sample_2)}
\item \code{"rcbd"}: \verb{(Rcpp::NumericMatrix block_as_column_data)}
\item \code{"association"}: \verb{(Rcpp::NumericVector sample_1, Rcpp::NumericVector sample_2)}
\item \code{"table"}: \verb{(Rcpp::IntegerMatrix contingency_table)}
}

Defining the test statistic using \code{R} follows a similar approach. The purpose of this design is to pre-calculate certain constants that remain invariant during permutation.
}
\examples{
pmt("twosample.wilcoxon")

pmts()

\donttest{
r <- define_pmt(
    inherit = "twosample", rejection = "lr", n_permu = 1e5,
    statistic = function(x, y) {
        m <- length(x)
        n <- length(y)
        function(x, y) sum(x) / m - sum(y) / n
    }
)

cpp <- define_pmt(
    inherit = "twosample", rejection = "lr", n_permu = 1e5,
    statistic = "[](NumericVector x, NumericVector y) {
        R_len_t n_x = x.size();
        R_len_t n_y = y.size();
        return [n_x, n_y](const NumericVector x, const NumericVector y) {
            double sum_x = 0;
            double sum_y = 0;
            for(auto x_i : x) sum_x += x_i;
            for(auto y_i : y) sum_y += y_i;
            return sum_x / n_x - sum_y / n_y;
        };
    }"
)

x <- rnorm(100)
y <- rnorm(100, 1)
options(LearnNonparam.pmt_progress = FALSE)
system.time(r$test(x, y))
system.time(cpp$test(x, y))
}

}
