% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Quantile.R
\name{Quantile}
\alias{Quantile}
\alias{onesample.quantile}
\title{Quantile Test}
\description{
Performs quantile test on a single sample. In addition, an estimation and a confidence interval for the desired quantile will be calculated.
}
\examples{
pmt(
    "onesample.quantile", prob = 0.5,
    null_value = 75, alternative = "greater",
    type = "asymp", correct = FALSE
)$test(Table1.1.1)$print()

pmt(
    "onesample.quantile",
    prob = 0.25, conf_level = 0.90
)$test(Table1.2.1)$conf_int

}
\section{Super classes}{
\code{\link[LearnNonparam:PermuTest]{LearnNonparam::PermuTest}} -> \code{\link[LearnNonparam:OneSampleTest]{LearnNonparam::OneSampleTest}} -> \code{Quantile}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{prob}}{The probability associated with the quantile.}

\item{\code{correct}}{Whether to apply continuity correction.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Quantile-new}{\code{Quantile$new()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="print"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-print'><code>LearnNonparam::PermuTest$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="test"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-test'><code>LearnNonparam::PermuTest$test()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="OneSampleTest" data-id="plot"><a href='../../LearnNonparam/html/OneSampleTest.html#method-OneSampleTest-plot'><code>LearnNonparam::OneSampleTest$plot()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Quantile-new"></a>}}
\if{latex}{\out{\hypertarget{method-Quantile-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Quantile} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Quantile$new(
  type = c("asymp", "exact"),
  alternative = c("two_sided", "less", "greater"),
  null_value = 0,
  conf_level = 0.95,
  prob = 0.5,
  correct = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{a character string specifying the way to calculate the p-value.}

\item{\code{alternative}}{a character string specifying the alternative hypothesis.}

\item{\code{null_value}}{a number indicating the hypothesized value of the quantile.}

\item{\code{conf_level}}{a number between zero and one indicating the confidence level to use.}

\item{\code{prob}}{a number between zero and one indicating the probability associated with the quantile.}

\item{\code{correct}}{a logical indicating whether to apply continuity correction in the normal approximation for the p-value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Quantile} object.
}
}
}
