% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexis.cohort.R
\name{lexis.cohort}
\alias{lexis.cohort}
\title{Emphasize a certain cohort in a Lexis grid}
\usage{
lexis.cohort(lg, cohort, fill = "green", alpha = 0.5)
}
\arguments{
\item{lg, }{an existing object originally created with \code{lexis.grid()}.}

\item{cohort}{numeric, set the cohort to highlight.}

\item{fill}{character, set the colour of the rectangle. Default is \code{"green"}.}

\item{alpha}{numeric, set the level of transparency of the rectangle. Default is \code{0.5}.}
}
\description{
Takes an existing Lexis grid and adds a coloured rectangle to highlight a certain cohort.
}
\details{
Takes an existing Lexis grid and adds a coloured rectangle to the plot. The rectangle will highlight a certain cohort in the Lexis grid.
}
\examples{
library(LexisPlotR)
lg <- lexis.grid(year.start = 1900, year.end = 1905, age.start = 0, age.end = 5)
lexis.cohort(lg = lg, cohort = 1901)
}
\author{
Philipp Ottolinger
}

