% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexis.lifeline.R
\name{lexis.lifeline}
\alias{lexis.lifeline}
\title{Plot lifelines into a Lexis grid}
\usage{
lexis.lifeline(lg, entry, exit = NA, lineends = F, colour = "red",
  alpha = 1, lwd = 0.5)
}
\arguments{
\item{lg, }{an existing object originally created with \code{lexis.grid()}.}

\item{entry}{character, set the entry or birth date of an individual in format \code{"YYYY-MM-DD"}.}

\item{exit}{character, set the exit or death date of an individual in format \code{"YYYY-MM-DD"}. Default is \code{NA} (no exit or death observed).}

\item{lineends}{logical, if \code{TRUE} lineends will be marked. Default is \code{FALSE}.}

\item{colour}{character, set the colour of the lifelines. Default is \code{"red"}.}

\item{alpha}{numeric, set the transparency of the lifelines. Default is \code{1} (no transparency).}

\item{lwd}{numeric, set the linewidth of the lifelines. Default is \code{0.5}.}
}
\value{
A ggplot2 object.
}
\description{
Add lifelines to an existing Lexis grid.
}
\details{
Takes an existing Lexis grid and adds lifelines to the grid. Input can be a single dates or dates from a vector.
}
\examples{
lg <- lexis.grid(year.start = 1900, year.end = 1905, age.start = 0, age.end = 5)
lexis.lifeline(lg = lg, entry = "1901-09-23")
lexis.lifeline(lg = lg, entry = "1901-09-23", exit = "1904-03-03")

}
\author{
Philipp Ottolinger
}

