% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randcensor.R
\name{randcensor}
\alias{randcensor}
\title{Generate Independent Random Censored Lifetime}
\usage{
randcensor(n, pcens = 0.1, timedistr = "lindley", censordistr = "lindley",
  ...)
}
\arguments{
\item{n}{number o generated observations.}

\item{pcens}{desired censoring rate.}

\item{timedistr}{a character string \code{'name'} naming a lifetime distribution for which the corresponding density function \code{dname}, the corresponding distribution function \code{pname} and the corresponding random function \code{qname}  are defined. The one-parameter \code{Lindley} distribution is taken as default.}

\item{censordistr}{a character string \code{'name'} naming the censoring distribution. 'lindley' (default) for the one-parameter Lindley distribution, 'exp' for the exponential distribution and 'unif' for the uniform distribution.}

\item{...}{parameters that define the event time distribution (timedistr). Must be provided in the same way as it is in built in R functions.}
}
\value{
\code{randcensor} returns a list with the timedistr distribution, the censordistr distribution, the calculated parameter of the censordist distribution and n observations which is either the lifetime (delta = 1) or a censored lifetime (delta = 0).

Invalid arguments will return an error message.
}
\description{
Implements a function to draw censored random samples, with a desired censoring rate, when the event times are any continuous lifetime distribution supported by R. The one-parameter Lindley, uniform and exponential are the distributions that can be used as the censoring distributions.
}
\note{
Finds the parameter of the censoring distribution using \code{\link[stats]{integrate}} and \code{\link[stats]{uniroot}}.
}
\examples{
x <- randcensor(n = 100, pcens = 0.2, timedistr = 'lindley', censordistr = 'lindley',
 theta = 1.5)
table(x$data['delta']) / 100

x <- randcensor(n = 100, pcens = 0.2, timedistr = 'wlindley', censordistr = 'lindley',
 theta = 1.5, alpha = 0.5)
table(x$data['delta']) / 100

x <- randcensor(n = 100, pcens = 0.2, timedistr = 'weibull', censordistr = 'lindley',
 shape = 0.5, scale = 1.5)
table(x$data['delta']) / 100

x <- randcensor(n = 100, pcens = 0.2, timedistr = 'lnorm', censordistr = 'unif',
 meanlog = 1, sdlog = 1)
table(x$data['delta']) / 100


}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}
}
\references{
Klein, J. P., Moeschberger, M. L., (2003). \emph{Survival Analysis: Techniques for Censored and Truncated Data, 2nd Edition}. Springer-Verlag, New York.

Lawless, J. F., (2003). \emph{Statistical models and methods for lifetime data, 2nd Edition}. Wiley Series in Probability and Statistics. John Wiley & Sons, Hoboken, NJ.

Meeker, W. Q., Escobar, L. A., (1998). \emph{Statistical Methods for Reliability Data}. John Wiley and Sons, New York.
}
\seealso{
\code{\link[stats]{Distributions}}, \code{\link[fitdistrplus]{fitdistcens}}, \code{\link[stats]{integrate}}, \code{\link[LindleyR]{Lindley}}, \code{\link[stats]{uniroot}}.
}

