% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinearDetect-package.R
\name{lm.sim.break}
\alias{lm.sim.break}
\title{Generate the linear regression model data with break points}
\usage{
lm.sim.break(
  nobs,
  px,
  cnst = NULL,
  phi = NULL,
  sigma,
  sigma_x = 1,
  brk = nobs + 1
)
}
\arguments{
\item{nobs}{number of time points}

\item{px}{the number of features}

\item{cnst}{the constant}

\item{phi}{parameter coefficient matrix of the linear model}

\item{sigma}{covariance matrix of the white noise}

\item{sigma_x}{variance of the predictor variable x}

\item{brk}{vector of break points}
}
\value{
A list object, which contains the followings
\describe{
  \item{series_y}{matrix of response data}
  \item{series_x}{matrix of predictor data}
  \item{noises}{matrix of white noise error}
}
}
\description{
Generate the linear regression model data with break points
}
