% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusteringLC.R
\name{SPSbalan}
\alias{SPSbalan}
\title{Test for Within-Bin X-covariate Balance in Supervised Propensiy Scoring}
\usage{
SPSbalan(envir, dframe, trtm, yvar, qbin, xvar, faclev = 3)
}
\arguments{
\item{envir}{The local control environment}

\item{dframe}{Name of augmented data.frame written to the appn="" argument of SPSlogit().}

\item{trtm}{Name of the two-level treatment factor variable.}

\item{yvar}{The outcome variable.}

\item{qbin}{Name of variable containing bin numbers.}

\item{xvar}{Name of one baseline covariate X variable used in the SPSlogit() PS model.}

\item{faclev}{Maximum number of different numerical values an X-covariate can assume without
automatically being converted into a "factor" variable; faclev=1 causes a binary indicator
to be treated as a continuous variable determining a proportion.}
}
\value{
An output list object of class SPSbalan. The first four are returned with a continuous x-variable. The next 4 are used if it is a factor variable.
\itemize{
  \item {aovdiff}{ANOVA output for marginal test.}
  \item {form2}{Formula for differences in X due to bins and to treatment nested within bins.}
  \item {bindiff}{ANOVA output for the nested within bin model.}
  \item {df3}{Output data.frame containing 3 variables: X-covariate, treatment and bin.}

  \item{factab}{Marginal table of counts by X-factor level and treatment.}
  \item{tab}{Three-way table of counts by X-factor level, treatment and bin.}
  \item{cumchi}{Cumulative Chi-Square statistic for interaction in the three-way, nested table.}
  \item{cumdf}{Degrees of-Freedom for the Cumulative Chi-Squared.}
}
}
\description{
Test for Conditional Independence of X-covariate Distributions from Treatment
  Selection within Given, Adjacent PS Bins. The second step in Supervised Propensity Scoring analyses is to verify that baseline
  X-covariates have the same distribution, regardless of treatment, within each fitted PS bin.
}
\references{
\itemize{
  \item Cochran WG. (1968) The effectiveness of adjustment by subclassification
  in removing bias in observational studies. \emph{Biometrics} \bold{24}:
  205-213.

  \item Obenchain RL. (2011) \bold{USPSinR.pdf}  USPS R-package vignette, 40 pages.

  \item Rosenbaum PR, Rubin RB. (1983) The Central Role of the Propensity Score
  in Observational Studies for Causal Effects. \emph{Biometrika} \bold{70}:
  41-55.

  \item Rosenbaum PR, Rubin DB. (1984) Reducing Bias in Observational Studies
  Using Subclassification on a Propensity Score. \emph{J Amer Stat Assoc}
  \bold{79}: 516-524.
}
}
\author{
Bob Obenchain <wizbob@att.net>
}
