#' @export

predict.logforest<-function(object, newdata, cutoff,...)
{
  if (!is(object,"logforest"))
    stop("object not of class logforest")
  nBS<-length(object$AllFits)
  trees<- object$AllFits
  mtype<-object$model.type
  if(mtype=="Classification")
  {
    if(missing(cutoff)) cutoff<-0.5

    if (missing(newdata))
    {
      LFprediction<-object$OOBprediction[,1]
      proportion_one<-object$OOBprediction[,2]
      ans<-list(model.type=mtype, LFprediction=LFprediction, proportion_one=proportion_one)
    }
    if (!missing(newdata))
    {
      pred<-ncol(newdata)
      if (pred!=object$predictors)
        stop("the predictors in newdata do not match the original predictors")
      size<-nrow(newdata)
      predict.new<-matrix(0, nrow=size, ncol=nBS)
      for (i in 1:nBS)
      {
        newX<-newdata[,1:pred]
        newpredict<-predict.logreg(object=trees[[i]], newbin=as.matrix(newX))
        predict.new[,i]<- newpredict
      }
      predictions<-proportion.positive(predictmatrix=predict.new, cutoff=cutoff)
      predmatrix<-cbind(predict.new, predictions$predmat)
      predframe<-as.data.frame(predmatrix)
      names(predframe)[1:nBS]<-paste("tree", 1:nBS, sep="")
      names(predframe)[nBS+1]<-paste("proportion_one")
      names(predframe)[nBS+2]<-paste("PredictedValue")
      ans<-list(model.type=mtype, LFprediction=predframe$PredictedValue, proportion_one=predframe$proportion_one,
                AllTrees=predframe)
    }
  }

  if(mtype=="Linear Regression")
  {
    if (missing(newdata))
    {
      LFprediction<-object$OOBprediction[,2]
      OOBmse<-object$OOBmiss
      ans<-list(model.type=mtype, LFprediction=LFprediction, OOBmse=OOBmse, ptype="OOBprediction")
    }
    if (!missing(newdata))
    {
      pred<-ncol(newdata)
      if (pred!=object$predictors)
        stop("the predictors in newdata do not match the original predictors")
      size<-nrow(newdata)
      predict.new<-matrix(0, nrow=size, ncol=nBS)
      for (i in 1:nBS)
      {
        newX<-newdata[,1:pred]
        newpredict<-predict.logreg(object=trees[[i]], newbin=as.matrix(newX))
        predict.new[,i]<- newpredict
      }
      predictions<-rowMeans(predict.new)
      predmatrix<-cbind(predict.new, predictions)
      predframe<-as.data.frame(predmatrix)
      names(predframe)[1:nBS]<-paste("tree", 1:nBS, sep="")
      names(predframe)[nBS+1]<-paste("PredictedValue")
      ans<-list(model.type=mtype, LFprediction=predframe$PredictedValue, AllTrees=predframe)
    }
  }
  class(ans)<-"LFprediction"
  return(ans)
}
