% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_RLum.R
\name{get_RLum}
\alias{get_RLum}
\alias{get_RLum.Analysis}
\alias{get_RLum.Data.Curve}
\alias{get_RLum.Data.Image}
\alias{get_RLum.Data.Spectrum}
\alias{get_RLum.Results}
\title{General accessor function for RLum S4 class objects}
\usage{
get_RLum(object, ...)
}
\arguments{
\item{object}{\code{\linkS4class{RLum}} (\bold{required}): S4 object of
class \code{RLum}}

\item{\dots}{further arguments that will be passed to the object specific methods. For
furter details on the supported arguments please see the class
documentation: \code{\linkS4class{RLum.Data.Curve}},
\code{\linkS4class{RLum.Data.Spectrum}}, \code{\linkS4class{RLum.Data.Image}},
\code{\linkS4class{RLum.Analysis}} and \code{\linkS4class{RLum.Results}}}
}
\value{
Return is the same as input objects as provided in the list.
}
\description{
Function calls object-specific get functions for RLum S4 class objects.
}
\details{
The function provides a generalised access point for specific
\code{\linkS4class{RLum}} objects.\cr Depending on the input object, the
corresponding get function will be selected. Allowed arguments can be found
in the documentations of the corresponding \code{\linkS4class{RLum}} class.
}
\section{Function version}{
 0.1 (2015-08-02 23:07:11)
}
\examples{
##Example based using data and from the calc_CentralDose() function

##load example data
data(ExampleData.DeValues, envir = environment())

##apply the central dose model 1st time
temp1 <- calc_CentralDose(ExampleData.DeValues$CA1)

##get results and store them in a new object
temp.get <- get_RLum(object = temp1)
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team}
\seealso{
\code{\linkS4class{RLum.Data.Curve}},
\code{\linkS4class{RLum.Data.Image}},
\code{\linkS4class{RLum.Data.Spectrum}},
\code{\linkS4class{RLum.Analysis}},
\code{\linkS4class{RLum.Results}}
}
\keyword{utilities}

