% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_OSLLxTxRatio.R
\name{calc_OSLLxTxRatio}
\alias{calc_OSLLxTxRatio}
\title{Calculate Lx/Tx ratio for CW-OSL curves}
\usage{
calc_OSLLxTxRatio(Lx.data, Tx.data, signal.integral,
  signal.integral.Tx = NULL, background.integral,
  background.integral.Tx = NULL,
  background.count.distribution = "non-poisson", sigmab)
}
\arguments{
\item{Lx.data}{\code{\linkS4class{RLum.Data.Curve}} or \link{data.frame}
(\bold{required}): requires a CW-OSL shine down curve (x = time, y = counts)}

\item{Tx.data}{\code{\linkS4class{RLum.Data.Curve}} or \link{data.frame}
(optional): requires a CW-OSL shine down curve (x = time, y = counts). If no
input is given the Tx.data will be treated as \code{NA} and no Lx/Tx ratio
is calculated.}

\item{signal.integral}{\code{\link{vector}} (\bold{required}): vector with the
limits for the signal integral.}

\item{signal.integral.Tx}{\code{\link{vector}} (optional): vector with the
limits for the signal integral for the Tx curve. If nothing is provided the
value from \code{signal.integral} is used.}

\item{background.integral}{\code{\link{vector}} (\bold{required}): vector with the
bounds for the background integral.}

\item{background.integral.Tx}{\code{\link{vector}} (optional): vector with the
limits for the background integral for the Tx curve. If nothing is provided the
value from \code{background.integral} is used.}

\item{background.count.distribution}{\code{\link{character}} (with default): Sets
the count distribution assumed for the error calculation. Possible arguments
\code{poisson} or \code{non-poisson}. See details for further information}

\item{sigmab}{\link{numeric} (optional): Option to set a manual value for
the overdispersion (for LnTx and TnTx), used for the Lx/Tx error
calculation. The value should be provided as absolute squared count values,
e.g. \code{sigmab = c(300,300)}. Note: If only one value is provided this
value is taken for both (LnTx and TnTx) signals.}
}
\value{
Returns an S4 object of type \code{\linkS4class{RLum.Results}}.

Slot \code{data} contains a \code{\link{list}} with the following structure:\cr
$LxTx.table (data.frame) \cr
.. $ LnLx \cr
.. $ LnLx.BG \cr
.. $ TnTx \cr
.. $ TnTx.BG \cr
.. $ Net_LnLx \cr
.. $ Net_LnLx.Error\cr
.. $ Net_TnTx.Error\cr
.. $ LxTx\cr
.. $ LxTx.Error \cr
$ calc.parameters (list) \cr
.. $ sigmab.LnTx\cr
.. $ sigmab.TnTx\cr
.. $ k \cr
$ call (original function call)\cr
}
\description{
Calculate Lx/Tx ratios from a given set of CW-OSL curves assuming late light background subtraction.
}
\details{
The integrity of the chosen values for the signal and background integral is
checked by the function; the signal integral limits have to be lower than
the background integral limits. If a \link{vector} is given as input instead
of a \link{data.frame}, an artificial \code{data.frame} is produced. The
error calculation is done according to Galbraith (2002).\cr

\bold{sigmab}\cr

The default value of \code{sigmab} is calculated assuming the background is
constant and \bold{would not} applicable when the background varies as,
e.g., as observed for the early light substraction method.

\bold{background.count.distribution}\cr

This argument allows selecting the distribution assumption that is used for
the error calculation. According to Galbraith (2002, 2014) the background
counts may be overdispersed (i.e. do not follow a poisson distribution,
which is assumed for the photomultiplier counts). In that case (might be the
normal case) it has to be accounted for the overdispersion by estimating
\eqn{\sigma^2} (i.e. the overdispersion value). Therefore the relative
standard error is calculated as:\cr\cr (a) \code{poisson}\cr
\deqn{rse(\mu_{S}) \approx \sqrt(Y_{0} + Y_{1}/k^2)/Y_{0} - Y_{1}/k} (b)
\code{non-poisson}\cr \deqn{rse(\mu_{S}) \approx \sqrt(Y_{0} + Y_{1}/k^2 +
\sigma^2(1+1/k))/Y_{0} - Y_{1}/k}

\bold{Please note} that when using the early background subtraction method in
combination with the 'non-poisson' distribution argument, the corresponding Lx/Tx error
may considerably increase due to a high sigmab value.
Please check whether this is valid for your data set and  if necessary
consider to provide an own sigmab value using the corresponding argument \code{sigmab}.
}
\note{
The results of this function have been cross-checked with the Analyst
(vers. 3.24b). Access to the results object via  \code{\link{get_RLum}}.\cr

\bold{Caution:} If you are using early light subtraction (EBG), please either provide your
own \code{sigmab} value or use \code{background.count.distribution = "poisson"}.
}
\section{Function version}{
 0.6.0 (2015-11-29 17:27:48)
}
\examples{

##load data
data(ExampleData.LxTxOSLData, envir = environment())

##calculate Lx/Tx ratio
results <- calc_OSLLxTxRatio(Lx.data, Tx.data, signal.integral = c(1:2),
                             background.integral = c(85:100))

##get results object
get_RLum(results)

}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team}
\seealso{
\code{\linkS4class{RLum.Data.Curve}},
\code{\link{Analyse_SAR.OSLdata}}, \code{\link{plot_GrowthCurve}},
\code{\link{analyse_SAR.CWOSL}}

 @references Duller, G., 2007. Analyst.
\url{http://www.nutech.dtu.dk/english/~/media/Andre_Universitetsenheder/Nutech/Produkter\%20og\%20services/Dosimetri/radiation_measurement_instruments/tl_osl_reader/Manuals/analyst_manual_v3_22b.ashx}\cr

Galbraith, R.F., 2002. A note on the variance of a background-corrected OSL
count. Ancient TL, 20 (2), 49-51.

Galbraith, R.F., 2014. A further note on the variance of a
background-corrected OSL count. Ancient TL, 31 (2), 1-3.
}
\keyword{datagen}

