% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RisoeBINfileData-class.R
\docType{class}
\name{Risoe.BINfileData-class}
\alias{Risoe.BINfileData-class}
\alias{show,Risoe.BINfileData-method}
\alias{set_Risoe.BINfileData,data.frame,list-method}
\alias{get_Risoe.BINfileData,Risoe.BINfileData-method}
\title{Class \code{"Risoe.BINfileData"}}
\usage{
\S4method{show}{Risoe.BINfileData}(object)

\S4method{set_Risoe.BINfileData}{data.frame,list}(METADATA, DATA, .RESERVED)

\S4method{get_Risoe.BINfileData}{Risoe.BINfileData}(object, ...)
}
\arguments{
\item{object}{an object of class \code{\linkS4class{Risoe.BINfileData}}}

\item{METADATA}{Object of class "data.frame" containing the meta information
for each curve.}

\item{DATA}{Object of class "list" containing numeric vector with count data.}

\item{.RESERVED}{Object of class "list" containing list of undocumented raw
values for internal use only.}

\item{...}{other arguments that might be passed}
}
\description{
S4 class object for luminescence data in R. The object is produced as output
of the function \code{\link{read_BIN2R}}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Show structure of RLum and Risoe.BINfile class objects

\item \code{set_Risoe.BINfileData}: The Risoe.BINfileData is normally produced as output of the function read_BIN2R.
This construction method is intended for internal usage only.

\item \code{get_Risoe.BINfileData}: Formal get-method for Risoe.BINfileData object. It does not allow accessing
the object directly, it is just showing a terminal message.
}}

\section{Slots}{

\describe{
\item{\code{METADATA}}{Object of class "data.frame" containing the meta information for each curve.}

\item{\code{DATA}}{Object of class "list" containing numeric vector with count data.}

\item{\code{.RESERVED}}{Object of class "list" containing list of undocumented raw values for internal use only.}
}}

\note{
\bold{Internal METADATA - object structure}

\tabular{rllll}{
\bold{#} \tab \bold{Name} \tab \bold{Data Type} \tab \bold{V} \tab \bold{Description} \cr
[,1]  \tab ID  \tab \code{numeric} \tab RLum \tab Unique record ID (same ID as in slot \code{DATA})\cr
[,2]  \tab SEL \tab \code{logic} \tab RLum \tab Record selection, not part official BIN-format, triggered by TAG\cr
[,3]  \tab VERSION \tab \code{raw} \tab 03-08 \tab BIN-file version number \cr
[,4]  \tab LENGTH \tab \code{integer} \tab 03-08 \tab Length of this record\cr
[,5]  \tab PREVIOUS \tab \code{integer} \tab 03-08 \tab Length of previous record\cr
[,6]  \tab NPOINTS \tab \code{integer} \tab 03-08 \tab Number of data points in the record\cr
[,7]  \tab RECTYPE \tab \code{integer} \tab 08 \tab Record type \cr
[,8]  \tab RUN \tab \code{integer} \tab 03-08 \tab Run number\cr
[,9]  \tab SET \tab \code{integer} \tab 03-08 \tab Set number\cr
[,10]  \tab POSITION \tab  \code{integer} \tab 03-08 \tab Position number\cr
[,11] \tab GRAIN \tab \code{integer} \tab 03-04 \tab Grain number\cr
[,12] \tab GRAINNUMBER \tab \code{integer} \tab 06-08 \tab Grain number\cr
[,13] \tab CURVENO \tab \code{integer} \tab 06-08 \tab Curve number\cr
[,14] \tab XCOORD \tab \code{integer} \tab 03-08 \tab X position of a single grain\cr
[,15] \tab YCOORD \tab \code{integer} \tab 03-08 \tab Y position of a single grain\cr
[,16] \tab SAMPLE \tab \code{factor} \tab 03-08 \tab Sample name\cr
[,17] \tab COMMENT \tab \code{factor} \tab 03-08 \tab Comment name\cr
[,18] \tab SYSTEMID \tab \code{integer} \tab 03-08 \tab Risoe system id\cr
[,19] \tab FNAME \tab \code{factor} \tab 06-08 \tab File name (*.bin/*.binx)\cr
[,20] \tab USER \tab \code{facotr} \tab 03-08 \tab User name\cr
[,21] \tab TIME \tab \code{character} \tab 03-08 \tab Data collection time (hh-mm-ss)\cr
[,22] \tab DATE \tab \code{factor} \tab 03-08 \tab Data collection date (ddmmyy)\cr
[,23] \tab DTYPE \tab \code{character} \tab 03-08 \tab Data type\cr
[,24] \tab BL_TIME \tab \code{numeric} \tab 03-08 \tab Bleaching time\cr
[,25] \tab BL_UNIT \tab \code{integer} \tab 03-08 \tab Bleaching unit (mJ, J, secs, mins, hrs)\cr
[,26] \tab NORM1 \tab \code{numeric} \tab 03-08 \tab Normalisation factor (1)\cr
[,27] \tab NORM2 \tab \code{numeric} \tab 03-08 \tab Normalisation factor (2)\cr
[,28] \tab NORM3 \tab \code{numeric} \tab 03-08 \tab Normalisation factor (3)\cr
[,29] \tab BG \tab \code{numeric} \tab 03-08 \tab Background level\cr
[,30] \tab SHIFT \tab \code{integer} \tab 03-08 \tab Number of channels to shift data\cr
[,31] \tab TAG \tab \code{integer} \tab 03-08 \tab Tag, triggers SEL\cr
[,32] \tab LTYPE \tab \code{character} \tab 03-08 \tab Luminescence type\cr
[,33] \tab LIGHTSOURCE \tab \code{character} \tab 03-08 \tab Light source\cr
[,34] \tab LPOWER \tab \code{numeric} \tab 03-08 \tab Optical stimulation power\cr
[,35] \tab LIGHTPOWER \tab \code{numeric} \tab 06-08 \tab Optical stimulation power\cr
[,36] \tab LOW \tab \code{numeric} \tab 03-08 \tab Low (temperature, time, wavelength)\cr
[,37] \tab HIGH \tab \code{numeric} \tab 03-08 \tab High (temperature, time, wavelength)\cr
[,38] \tab RATE \tab \code{numeric} \tab 03-08 \tab Rate (heating rate, scan rate)\cr
[,39] \tab TEMPERATURE \tab \code{integer} \tab 03-08 \tab Sample temperature\cr
[,40] \tab MEASTEMP \tab \code{integer} \tab 06-08 \tab Measured temperature\cr
[,41] \tab AN_TEMP \tab \code{numeric} \tab 03-08 \tab Annealing temperature\cr
[,42] \tab AN_TIME \tab \code{numeric} \tab 03-08 \tab Annealing time\cr
[,43] \tab TOLDELAY \tab \code{integer} \tab 03-08 \tab TOL 'delay' channels\cr
[,44] \tab TOLON \tab \code{integer} \tab 03-08 \tab TOL 'on' channels\cr
[,45] \tab TOLOFF \tab \code{integer} \tab 03-08 \tab TOL 'off' channels\cr
[,46] \tab IRR_TIME \tab \code{numeric} \tab 03-08 \tab Irradiation time\cr
[,47] \tab IRR_TYPE \tab \code{integer} \tab 03-08 \tab Irradiation type (alpha, beta or gamma)\cr
[,48] \tab IRR_UNIT \tab \code{integer} \tab 03-04 \tab Irradiation unit (Gy, Rads, secs, mins, hrs)\cr
[,49] \tab IRR_DOSERATE \tab \code{numeric} \tab 06-08 \tab Irradiation dose rate (Gy/s)\cr
[,50] \tab IRR_DOSERATEERR \tab \code{numeric} \tab 06-08 \tab Irradiation dose rate error (Gy/s)\cr
[,51] \tab TIMESINCEIRR \tab \code{integer} \tab 06-08 \tab Time since irradiation (s)\cr
[,52] \tab TIMETICK \tab \code{numeric} \tab 06-08 \tab Time tick for pulsing (s)\cr
[,53] \tab ONTIME \tab \code{integer} \tab 06-08 \tab On-time for pulsing (in time ticks)\cr
[,54] \tab STIMPERIOD \tab \code{integer} \tab 06-08 \tab Stimulation period (on+off in time ticks)\cr
[,55] \tab GATE_ENABLED \tab \code{raw} \tab 06-08 \tab PMT signal gating enabled\cr
[,56] \tab ENABLE_FLAGS \tab \code{raw} \tab 06-08 \tab PMT signal gating  enabled\cr
[,57] \tab GATE_START \tab \code{integer} \tab 06-08 \tab Start gating (in time ticks)\cr
[,58] \tab GATE_STOP \tab \code{ingeter} \tab 06-08 \tab Stop gating (in time ticks), 'Gateend' for version 04, here only GATE_STOP is used\cr
[,59] \tab PTENABLED \tab \code{raw} \tab 06-08 \tab Photon time enabled\cr
[,60] \tab DTENABLED \tab \code{raw} \tab 06-08 \tab PMT dead time correction enabled\cr
[,61] \tab DEADTIME \tab \code{numeric} \tab 06-08 \tab PMT dead time (s)\cr
[,62] \tab MAXLPOWER \tab \code{numeric} \tab 06-08 \tab Stimulation power to 100 percent (mW/cm^2)\cr
[,63] \tab XRF_ACQTIME \tab \code{numeric} \tab 06-08 \tab XRF acquisition time (s)\cr
[,64] \tab XRF_HV \tab \code{numeric} \tab 06-08 \tab XRF X-ray high voltage (V)\cr
[,65] \tab XRF_CURR \tab \code{integer} \tab 06-08 \tab XRF X-ray current (uA)\cr
[,66] \tab XRF_DEADTIMEF \tab \code{numeric} \tab 06-08 \tab XRF dead time fraction\cr
[,67] \tab SEQUENCE \tab \code{character} \tab 03-04 \tab Sequence name\cr
[,68] \tab DETECTOR_ID \tab \code{raw} \tab 07-08 \tab Detector ID\cr
[,69] \tab LOWERFILTER_ID \tab \code{integer} \tab 07-08 \tab Lower filter ID in reader\cr
[,70] \tab UPPERFILTER_ID \tab \code{integer} \tab 07-08 \tab Uper filter ID in reader\cr
[,71] \tab ENOISEFACTOR \tab \code{numeric} \tab 07-08 \tab Excess noise filter, usage unknown \cr
[,72] \tab MARKPOS_X1 \tab \code{numeric} \tab 08 \tab Coordinates marker position 1 \cr
[,73] \tab MARKPOS_Y1 \tab \code{numeric} \tab 08 \tab Coordinates marker position 1 \cr
[,74] \tab MARKPOS_X2 \tab \code{numeric} \tab 08 \tab Coordinates marker position 2 \cr
[,75] \tab MARKPOS_Y2 \tab \code{numeric} \tab 08 \tab Coordinates marker position 2 \cr
[,76] \tab MARKPOS_X3 \tab \code{numeric} \tab 08 \tab Coordinates marker position 3 \cr
[,77] \tab MARKPOS_Y3 \tab \code{numeric} \tab 08 \tab Coordinates marker position 3 \cr
[,78] \tab MARKPOS_X4 \tab \code{numeric} \tab 08 \tab Coordinates marker position 4 \cr
[,79] \tab MARKPOS_Y4 \tab \code{numeric} \tab 08 \tab Coordinates marker position 4 \cr
[,80] \tab EXTR_START \tab \code{numeric} \tab 08 \tab usage unknown \cr
[,81] \tab EXTR_END \tab \code{numeric} \tab 08 \tab usage unknown
} V = BIN-file version (RLum means that it does not depend on a specific BIN
version)\cr

Note that the \code{Risoe.BINfileData} object combines all values from
different versions from the BIN-file, reserved bits are skipped, however,
the function \code{\link{write_R2BIN}} reset arbitrary reserved bits. Invalid
values for a specific version are set to \code{NA}. Furthermore, the
internal R data types do not necessarily match the required data types for
the BIN-file data import! Data types are converted during data import.\cr

\bold{LTYPE} values

\tabular{rll}{ [,0] \tab TL \tab: Thermoluminescence \cr [,1] \tab OSL \tab:
Optically stimulated luminescence \cr [,2] \tab IRSL \tab: Infrared
stimulated luminescence \cr [,3] \tab M-IR \tab: Infrared monochromator
scan\cr [,4] \tab M-VIS \tab: Visible monochromator scan\cr [,5] \tab TOL
\tab: Thermo-optical luminescence \cr [,6] \tab TRPOSL \tab: Time Resolved
Pulsed OSL\cr [,7] \tab RIR \tab: Ramped IRSL\cr [,8] \tab RBR \tab: Ramped
(Blue) LEDs\cr [,9] \tab USER \tab: User defined\cr [,10] \tab POSL \tab:
Pulsed OSL \cr [,11] \tab SGOSL \tab: Single Grain OSL\cr [,12] \tab RL
\tab: Radio Luminescence \cr [,13] \tab XRF \tab: X-ray Fluorescence }

\bold{DTYPE} values \tabular{rll}{ [,0] \tab 0 \tab Natural \cr [,1] \tab 1
\tab N+dose \cr [,2] \tab 2 \tab Bleach \cr [,3] \tab 3 \tab Bleach+dose \cr
[,4] \tab 4 \tab Natural (Bleach) \cr [,5] \tab 5 \tab N+dose (Bleach) \cr
[,6] \tab 6 \tab Dose \cr [,7] \tab 7 \tab Background }

\bold{LIGHTSOURCE} values \tabular{rll}{ [,0] \tab 0 \tab Non \cr [,1] \tab
1 \tab Lamp \cr [,2] \tab 2 \tab IR diodes/IR Laser \cr [,3] \tab 3 \tab
Calibration LED \cr [,4] \tab 4 \tab Blue Diodes \cr [,5] \tab 5 \tab White
lite \cr [,6] \tab 6 \tab Green laser (single grain) \cr [,7] \tab 7 \tab IR
laser (single grain) }

(information on the BIN/BINX file format are kindly provided by Risoe, DTU
Nutech)
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("Risoe.BINfileData", ...)}.
}

\section{Function version}{
 0.3.1
}

\examples{

showClass("Risoe.BINfileData")

} 

\section{How to cite}{
Kreutzer, S. (2017). Risoe.BINfileData-class(): Class 'Risoe.BINfileData'. Function version 0.3.1. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.0. https://CRAN.R-project.org/package=Luminescence
}

\references{
Risoe DTU, 2013. The Sequence Editor User Manual - Feb 2013 and Risoe DTU, 2016. The
Sequence Editor User Manual - Feburar 2016

\code{http://www.nutech.dtu.dk/}
}
\seealso{
\code{\link{plot_Risoe.BINfileData}}, \code{\link{read_BIN2R}},
\code{\link{write_R2BIN}},\code{\link{merge_Risoe.BINfileData}},
\code{\link{Risoe.BINfileData2RLum.Analysis}},
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team}
\keyword{classes}
