% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSL2Risoe.BINfileData.R
\name{PSL2Risoe.BINfileData}
\alias{PSL2Risoe.BINfileData}
\title{Convert portable OSL data to an Risoe.BINfileData object}
\usage{
PSL2Risoe.BINfileData(object, ...)
}
\arguments{
\item{object}{\code{\linkS4class{RLum.Analysis}} (\bold{required}):
\code{RLum.Analysis} object produced by \code{\link{read_PSL2R}}}

\item{...}{currently not used.}
}
\value{
Returns an S4 \code{\linkS4class{Risoe.BINfileData}} object that can
be used to write a BIN file using \code{\link{write_R2BIN}}.
}
\description{
Converts an \code{RLum.Analysis} object produced by the function \code{read_PSL2R()} to
an \code{Risoe.BINfileData} object \bold{(BETA)}.
}
\details{
This function converts an \code{\linkS4class{RLum.Analysis}} object that was produced
by the \code{\link{read_PSL2R}} function to an \code{\linkS4class{Risoe.BINfileData}}.
The \code{Risoe.BINfileData} can be used to write a Risoe BIN file via
\code{\link{write_R2BIN}}.
}
\section{Function version}{
 0.0.1 (2017-02-10 18:30:04)
}

\examples{

# (1) load and plot example data set
data("ExampleData.portableOSL", envir = environment())
plot_RLum(ExampleData.portableOSL)

# (2) merge all RLum.Analysis objects into one
merged <- merge_RLum(ExampleData.portableOSL)
merged

# (3) convert to RisoeBINfile object
bin <- PSL2Risoe.BINfileData(merged)
bin

# (4) write Risoe BIN file
\dontrun{
write_R2BIN(bin, "~/portableOSL.binx")
}

}
\seealso{
\code{\linkS4class{RLum.Analysis}}, \code{\linkS4class{RLum.Data.Curve}},
\code{\linkS4class{Risoe.BINfileData}}
}
\author{
Christoph Burow, University of Cologne (Germany)
\cr R Luminescence Package Team} 

\section{How to cite}{
Burow, C. (2017). PSL2Risoe.BINfileData(): Convert portable OSL data to an Risoe.BINfileData object. Function version 0.0.1. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.4. https://CRAN.R-project.org/package=Luminescence
}

\keyword{IO}
