% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_Daybreak2CSV.R
\name{convert_Daybreak2CSV}
\alias{convert_Daybreak2CSV}
\title{Export measurement data produced by a Daybreak luminescence reader to CSV-files}
\usage{
convert_Daybreak2CSV(file, ...)
}
\arguments{
\item{file}{\link{character} (\strong{required}):
name of the Daybreak-file (TXT-file, DAT-file) to be converted to CSV-files}

\item{...}{further arguments that will be passed to the function
\link{read_Daybreak2R} and \link{write_RLum2CSV}}
}
\value{
The function returns either a CSV-file (or many of them) or for the option \code{export = FALSE}
a list comprising objects of type \link{data.frame} and \link{matrix}
}
\description{
This function is a wrapper function around the functions \link{read_Daybreak2R} and
\link{write_RLum2CSV} and it imports an Daybreak-file (TXT-file, DAT-file)
and directly exports its content to CSV-files.  If nothing is set for the
argument \code{path} (\link{write_RLum2CSV}) the input folder will become the output folder.
}
\section{Function version}{
 0.1.0
}

\examples{

\dontrun{
##select your BIN-file
file <- file.choose()

##convert
convert_Daybreak2CSV(file)

}

}
\seealso{
\linkS4class{RLum.Analysis}, \linkS4class{RLum.Data}, \linkS4class{RLum.Results},
\link[utils:write.table]{utils::write.table}, \link{write_RLum2CSV}, \link{read_Daybreak2R}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2019. convert_Daybreak2CSV(): Export measurement data produced by a Daybreak luminescence reader to CSV-files. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., 2019. Luminescence: Comprehensive Luminescence Dating Data AnalysisR package version 0.9.2. https://CRAN.R-project.org/package=Luminescence
}

\keyword{IO}
