% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_RLum.R
\name{set_RLum}
\alias{set_RLum}
\title{General set function for RLum S4 class objects}
\usage{
set_RLum(class, originator, .uid = create_UID(), .pid = NA_character_,
  ...)
}
\arguments{
\item{class}{\linkS4class{RLum} (\strong{required}):
name of the S4 class to create}

\item{originator}{\link{character} (\emph{automatic}):
contains the name of the calling function (the function that produces this object);
can be set manually.}

\item{.uid}{\link{character} (\emph{automatic}):
sets an unique ID for this object using the internal C++ function \code{create_UID}.}

\item{.pid}{\link{character} (\emph{with default}):
option to provide a parent id for nesting at will.}

\item{...}{further arguments that one might want to pass to the specific set method}
}
\value{
Returns an object of the specified class.
}
\description{
Function calls object-specific set functions for RLum S4 class objects.
}
\details{
The function provides a generalised access point for specific
\linkS4class{RLum} objects.\cr
Depending on the given class, the corresponding method to create an object
from this class will be selected. Allowed additional arguments can be found
in the documentations of the corresponding \linkS4class{RLum} class:
\itemize{
\item \linkS4class{RLum.Data.Curve},
\item \linkS4class{RLum.Data.Image},
\item \linkS4class{RLum.Data.Spectrum},
\item \linkS4class{RLum.Analysis},
\item \linkS4class{RLum.Results}
}
}
\section{Function version}{
 0.3.0
}

\examples{

##produce empty objects from each class
set_RLum(class = "RLum.Data.Curve")
set_RLum(class = "RLum.Data.Spectrum")
set_RLum(class = "RLum.Data.Spectrum")
set_RLum(class = "RLum.Analysis")
set_RLum(class = "RLum.Results")

##produce a curve object with arbitrary curve values
object <- set_RLum(
class = "RLum.Data.Curve",
curveType = "arbitrary",
recordType = "OSL",
data = matrix(c(1:100,exp(-c(1:100))),ncol = 2))

##plot this curve object
plot_RLum(object)

}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Image},
\linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Analysis}, \linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2019. set_RLum(): General set function for RLum S4 class objects. Function version 0.3.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., 2019. Luminescence: Comprehensive Luminescence Dating Data AnalysisR package version 0.9.2. https://CRAN.R-project.org/package=Luminescence
}

\keyword{utilities}
