% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_seq_download.R
\name{auto_seq_download}
\alias{auto_seq_download}
\title{Automatic Sequence Download}
\usage{
auto_seq_download(BOLD_database = 1, NCBI_database = 1, search_str = "N")
}
\arguments{
\item{BOLD_database}{1 is to include, 0 is to exclude; default 1}

\item{NCBI_database}{1 is to include, 0 is to exclude; default 1}

\item{search_str}{N uses the default string, anything other than N then that string will be used for the GenBank search; default N.
The Default String is: (genus[ORGN] OR genus[ALL]) NOT (shotgun[ALL] OR genome[ALL] OR assembled[ALL] OR microsatellite[ALL])}
}
\value{
Outputs: One main folder containing three other folders.
Main folder - Seq_auto_dl_######_MMM_DD
Three subfolders:
1. BOLD - Contains a file for every genus downloaded with the raw data from the BOLD system.
2. NCBI - Contains a file for every genus downloaded with the raw data from GenBank.
3. Total_tables - Contains files for the running of the function which include...
A_Summary.txt - This file contains information about the downloads.
A file with a single table containing the accumulated data for all genera searched.
}
\description{
Takes a list of genera, as supplied by the user, and searches and downloads molecular sequence data from BOLD and Genbank.
}
\details{
User Input: A list of genera in a text file in a single column with a new line at the end of the list.
}
\note{
When using a custom search string for NCBI only a single genus at a time can be used.
}
\examples{
\dontrun{
auto_seq_download()
auto_seq_download(BOLD_database = 1,NCBI_database = 0)
auto_seq_download(BOLD_database = 0,NCBI_database = 1)
}

}
\references{
<https://github.com/rgyoung6/MACER>
Young, R. G., Gill, R., Gillis, D., Hanner, R. H. (Submitted June 2021). Molecular Acquisition, Cleaning, and Evaluation in R (MACER) - A tool to assemble molecular marker datasets from BOLD and GenBank. Biodiversity Data Journal.
}
\seealso{
create_fastas()
align_to_ref()
barcode_clean()
}
\author{
Robert G. Young
}
