/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.io;

import java.io.File;
import uk.ac.rhul.cs.cl1.io.CSVClusteringWriter;
import uk.ac.rhul.cs.cl1.io.ClusteringWriter;
import uk.ac.rhul.cs.cl1.io.GeneProClusteringWriter;
import uk.ac.rhul.cs.cl1.io.PlainTextClusteringWriter;
import uk.ac.rhul.cs.utils.StringUtils;

public class ClusteringWriterFactory {
    public static ClusteringWriter fromFormat(Format format) {
        switch (format) {
            case PLAIN: {
                return new PlainTextClusteringWriter();
            }
            case CSV: {
                return new CSVClusteringWriter();
            }
            case GENEPRO: {
                return new GeneProClusteringWriter();
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        PLAIN("Cluster list", "txt", "text/plain"),
        CSV("CSV-formatted detailed cluster list", "csv", "text/csv"),
        GENEPRO("GenePro formatted cluster list", "tab", "text/tab-separated-values");

        private String extension;
        private String name;
        private String mimeType;

        private Format(String name, String extension, String mimeType) {
            this.name = name;
            this.extension = extension;
            this.mimeType = mimeType;
        }

        public static Format forFile(File file) {
            String extension = StringUtils.getFileExtension(file);
            for (Format format : Format.values()) {
                if (!format.extension.equals(extension)) continue;
                return format;
            }
            return null;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getName() {
            return this.name;
        }
    }
}

