/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import uk.ac.rhul.cs.cl1.io.AbstractGraphWriter;
import uk.ac.rhul.cs.graph.Edge;
import uk.ac.rhul.cs.graph.Graph;
import uk.ac.rhul.cs.utils.ArrayUtils;

public class EdgeListWriter
extends AbstractGraphWriter {
    public void writeGraph(Graph graph, OutputStream stream) throws IOException {
        double minWeight;
        boolean writeWeights;
        String[] names = graph.getNodeNames();
        double[] weights = graph.getEdgeWeights();
        PrintWriter wr = new PrintWriter(stream);
        boolean bl = writeWeights = weights.length > 0;
        if (writeWeights && ((minWeight = ArrayUtils.min(weights)) == 1.0 || minWeight == 0.0) && ArrayUtils.max(weights) == minWeight) {
            writeWeights = false;
        }
        for (int i = 0; i < names.length; ++i) {
            if (names[i] != null) continue;
            names[i] = Integer.toString(i);
        }
        if (writeWeights) {
            for (Edge e : graph) {
                wr.println(names[e.source] + '\t' + names[e.target] + '\t' + weights[e.index]);
            }
        } else {
            for (Edge e : graph) {
                wr.println(names[e.source] + '\t' + names[e.target]);
            }
        }
        wr.flush();
    }
}

