/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui;

import com.sosnoski.util.hashmap.ObjectIntHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import uk.ac.rhul.cs.cl1.ClusterONE;
import uk.ac.rhul.cs.cl1.CohesivenessFunction;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.QualityFunction;
import uk.ac.rhul.cs.cl1.ValuedNodeSet;
import uk.ac.rhul.cs.cl1.ui.GraphRenderer;
import uk.ac.rhul.cs.cl1.ui.NodeSetDetails;
import uk.ac.rhul.cs.graph.FruchtermanReingoldLayoutAlgorithm;
import uk.ac.rhul.cs.graph.Graph;
import uk.ac.rhul.cs.graph.GraphLayoutAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSetTableModel
extends AbstractTableModel {
    private static final Color DARK_RED = new Color(128, 0, 0);
    protected final QualityFunction qualityFunc = new CohesivenessFunction();
    String[] simpleHeaders = new String[]{"Cluster", "Details"};
    Class<?>[] simpleClasses = new Class[]{ImageIcon.class, NodeSetDetails.class};
    String[] detailedHeaders = new String[]{"Cluster", "Nodes", "Density", "In-weight", "Out-weight", "Quality", "P-value"};
    Class<?>[] detailedClasses = new Class[]{ImageIcon.class, Integer.class, Double.class, Double.class, Double.class, Double.class, Double.class};
    String[] currentHeaders = null;
    Class<?>[] currentClasses = null;
    protected List<ValuedNodeSet> nodeSets = null;
    protected List<Future<Icon>> nodeSetIcons = new ArrayList<Future<Icon>>();
    protected List<NodeSetDetails> nodeSetDetails = new ArrayList<NodeSetDetails>();
    boolean detailedMode = true;
    private Icon progressIcon = null;

    public NodeSetTableModel(List<ValuedNodeSet> nodeSets) {
        this.nodeSets = new ArrayList<ValuedNodeSet>(nodeSets);
        this.updateNodeSetDetails();
        this.setDetailedMode(false);
    }

    @Override
    public int getColumnCount() {
        return this.currentHeaders.length;
    }

    @Override
    public int getRowCount() {
        return this.nodeSets.size();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return this.currentClasses[col];
    }

    @Override
    public String getColumnName(int col) {
        return this.currentHeaders[col];
    }

    public String[] getMemberNames(int row) {
        NodeSet nodeSet = this.nodeSets.get(row);
        if (nodeSet == null) {
            return new String[0];
        }
        return nodeSet.getMemberNames();
    }

    @Override
    public Object getValueAt(int row, int col) {
        NodeSet nodeSet = this.nodeSets.get(row);
        if (nodeSet == null) {
            return null;
        }
        if (col == 0) {
            try {
                Future<Icon> icon = this.nodeSetIcons.get(row);
                if (icon != null && icon.isDone()) {
                    return icon.get();
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            return this.getProgressIcon();
        }
        if (!this.detailedMode) {
            return this.nodeSetDetails.get(row);
        }
        if (col == 1) {
            return nodeSet.size();
        }
        if (col == 2) {
            return nodeSet.getDensity();
        }
        if (col == 3) {
            return nodeSet.getTotalInternalEdgeWeight();
        }
        if (col == 4) {
            return nodeSet.getTotalBoundaryEdgeWeight();
        }
        if (col == 5) {
            return this.qualityFunc.calculate(nodeSet);
        }
        if (col == 6) {
            return nodeSet.getSignificance();
        }
        return "TODO";
    }

    private Icon getProgressIcon() {
        return this.progressIcon;
    }

    public NodeSet getNodeSetByIndex(int row) {
        return this.nodeSets.get(row);
    }

    public boolean isInDetailedMode() {
        return this.detailedMode;
    }

    public void remove(NodeSet nodeSet) {
        int index = this.nodeSets.indexOf(nodeSet);
        if (index < 0) {
            return;
        }
        this.nodeSets.remove(index);
        this.nodeSetIcons.remove(index);
        this.nodeSetDetails.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void setDetailedMode(boolean mode) {
        if (mode == this.detailedMode) {
            return;
        }
        this.detailedMode = mode;
        this.currentHeaders = this.detailedMode ? this.detailedHeaders : this.simpleHeaders;
        this.currentClasses = this.detailedMode ? this.detailedClasses : this.simpleClasses;
        this.fireTableStructureChanged();
    }

    public void setProgressIcon(Icon value) {
        this.progressIcon = value;
    }

    private void updateNodeSetDetails() {
        Executor threadPool = ClusterONE.getThreadPool();
        int i = 0;
        this.nodeSetDetails.clear();
        this.nodeSetIcons.clear();
        for (ValuedNodeSet nodeSet : this.nodeSets) {
            HashMap<Integer, Color> subgraphColorMap = new HashMap<Integer, Color>();
            Graph subgraph = nodeSet.getSubgraph();
            ObjectIntHashMap nodeNameIndex = subgraph.getNodeNameHashMap();
            boolean onlyCores = true;
            for (int nodeIndex : nodeSet) {
                if (nodeSet.getValue(nodeIndex) <= 1) continue;
                onlyCores = false;
                break;
            }
            if (!onlyCores) {
                for (int nodeIndex : nodeSet) {
                    int id;
                    if (nodeSet.getValue(nodeIndex) != 1 || (id = nodeNameIndex.get(Integer.toString(nodeIndex))) == Integer.MIN_VALUE) continue;
                    subgraphColorMap.put(id, DARK_RED);
                }
            }
            RendererTask rendererTask = new RendererTask(i, subgraph, new FruchtermanReingoldLayoutAlgorithm(), subgraphColorMap);
            threadPool.execute(rendererTask);
            this.nodeSetIcons.add(rendererTask);
            this.nodeSetDetails.add(new NodeSetDetails(nodeSet));
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RendererTask
    extends FutureTask<Icon> {
        int rowIndex;

        public RendererTask(int rowIndex, Graph subgraph, GraphLayoutAlgorithm algorithm, HashMap<Integer, Color> colorMapping) {
            super(new GraphRenderer(subgraph, algorithm, colorMapping));
            this.rowIndex = rowIndex;
        }

        @Override
        protected void done() {
            NodeSetTableModel.this.fireTableCellUpdated(this.rowIndex, 0);
        }
    }
}

