% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keepMT.R
\name{keepMT}
\alias{keepMT}
\title{Keep Mitochondrial (mt) Proteins}
\usage{
keepMT(x)
}
\arguments{
\item{x}{A data matrix  object with rows
including proteins and fractions along the columns.}
}
\value{
Matrix containing mt proteins.
}
\description{
This function removes all the non-mitochondrial proteins by
mapping the co-eluted proteins from chromatography fractions to
MitoCarta database.
Note that this function is only applicable to mouse or human organisms.
}
\details{
keepMT
}
\examples{
# Load the co-elution data
data("exampleData")
# Removes non-mitochondtial proteins
datOut <- keepMT(exampleData)
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
