% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subcellular.mtPPI.R
\name{subcellular.mtPPI}
\alias{subcellular.mtPPI}
\title{Keep Mitochondrial (mt) Proteins}
\usage{
subcellular.mtPPI(ppi, organism = "mouse")
}
\arguments{
\item{ppi}{Interactions data containing id1-id2-weight triplets.}

\item{organism}{Organism under study (i.e., mouse or human).
Defaults to mouse.}
}
\value{
Filtered PPI netwrok.
}
\description{
This function removes PPIs occurring between outer mt
membrane (OMM) and matrix, between intermembrane space (IMS) and matrix,
as well as between any subcellular mt compartment (except OMM) and
cytosolic proteins as they deemed to be erroneous
}
\details{
subcellular.mtPPI
}
\examples{
ppi <-
read.table(system.file("extdata/ppi_input_ClusterONE.txt",
package="MACP"),
quote="\"", comment.char="")
filtered_mtEdges <- subcellular.mtPPI(ppi)
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
