% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{createOncoMatrix}
\alias{createOncoMatrix}
\title{Creates matrix for oncoplot}
\usage{
createOncoMatrix(maf, g = NULL, add_missing = FALSE)
}
\arguments{
\item{maf}{The MAF object}

\item{g}{g}

\item{add_missing}{add_missing}
}
\value{
A list of objects to be used as an input for \link[MAFDash]{generateOncoPlot} function
}
\description{
Creates matrix for oncoplot from maf file
}
\examples{
library(MAFDash)
library(maftools)
maf <- system.file("extdata", "test.mutect2.maf.gz", package = "MAFDash")
oncoMatrix<-createOncoMatrix(read.maf(maf),g=c("GNA11","MACF1"))
}
\author{
Mayank Tandon, Ashish Jain
}
