% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateChauvenetCriterion.R
\name{calculateChauvenetCriterion}
\alias{calculateChauvenetCriterion}
\title{Calculate Chauvenet's criterion for outlier detection}
\usage{
calculateChauvenetCriterion(x)
}
\arguments{
\item{x}{numeric, values (e.g. intensities) to test for outliers}
}
\value{
logical vector, TRUE for detected outliers.
}
\description{
Calculate Chauvenet's criterion for outlier detection
}
\details{
Note that, as for all outlier detection criteria:
Excluding data points from your measurement should only be conducted with extreme care.
Even if this (or any other) function tells you that a data point is an outlier,
you might still want to have it in your sample population especially if you are not sure if your data is normal distributed.
See \href{https://en.wikipedia.org/wiki/Chauvenet\%27s_criterion}{Wikipedia} for details of the algorithm.
}
\examples{
set.seed(42) 

#no outlier
sample <- rnorm(n = 8, mean = 0, sd = 0.01)
calculateChauvenetCriterion(sample)

# introduce outlier
sample[1] <- 1
calculateChauvenetCriterion(sample)

}
