% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateCurveFit.R
\name{calculateCurveFit}
\alias{calculateCurveFit}
\title{Calculate the fit for a dose-response curve}
\usage{
calculateCurveFit(intmat, idx, verbose = TRUE, ...)
}
\arguments{
\item{intmat}{Intensity matrix as generated by
\code{MALDIquant::intensityMatrix()}
with rownames as the respective concentrations of the spectra.}

\item{idx}{Numeric vector of the mz indices to perform the fit.}

\item{verbose}{Logical, print logs to console.}

\item{...}{Additional arguments passed to \code{nplr::nplr()}.}
}
\value{
List of curve fits.
}
\description{
Calculate the fit for a dose-response curve
}
\examples{
data(Blank2022intmat)

# for faster runtime we let it run on 5 peaks only
fits <- calculateCurveFit(Blank2022intmat, idx = 1:5)
}
