% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculatePeakstatistics.R
\name{calculatePeakStatistics}
\alias{calculatePeakStatistics}
\title{Calculate peak statistics}
\usage{
calculatePeakStatistics(curveFits, singlePeaks, spec)
}
\arguments{
\item{curveFits}{list of curve fits as returned by \code{MALDIcellassay::calculateCurveFit()}.}

\item{singlePeaks}{list of MALDIquant::MassPeaks.}

\item{spec}{list of MALDIquant::MassSpectrum.}
}
\value{
A tibble with peak statistics.
}
\description{
Calculate peak statistics
}
\examples{
data(Blank2022intmat)
fits <- calculateCurveFit(Blank2022intmat, idx = 1:5)

peakstats <- calculatePeakStatistics(curveFits = fits, 
                                     singlePeaks = Blank2022peaks, 
                                     spec = Blank2022spec)
head(peakstats)
}
