% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{getIntensityMatrix}
\alias{getIntensityMatrix}
\title{Get the intensity matrix of single spectra for all fitted curves}
\usage{
getIntensityMatrix(object, avg = FALSE, excludeNormMz = FALSE)
}
\arguments{
\item{object}{Object of class MALDIassay}

\item{avg}{Logical, return single spectra intensity matrix (default) or average spectra intensity matrix}

\item{excludeNormMz}{Logical, exclude normMz from intensity matrix.}
}
\value{
A matrix with columns as \emph{m/z} values and rows as concentrations/spectra
}
\description{
Get the intensity matrix of single spectra for all fitted curves
}
\details{
Note that the returned matrix only contains \emph{m/z} values that were actually fitted.
If a variance filtering step was applied this will not include \strong{all} \emph{m/z} values.
If you wish to get a matrix of \strong{all} \emph{m/z} values use \code{MALDIquant::intensityMatrix(getSinglePeaks(object))}.
For average spectra intensity matrix with \strong{all} \emph{m/z} values use \code{MALDIquant::intensityMatrix(getAvgPeaks(object), getAvgSpectra(object))}.
}
\examples{
# see example for `fitCurve()` to see how this data was generated
data(Blank2022res)
head(getIntensityMatrix(Blank2022res, avg = TRUE, excludeNormMz = TRUE) )
}
