% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_02_2_0_PropModality.R
\name{PropModality}
\alias{PropModality}
\title{Modality Proportion}
\usage{
PropModality(MarvelObject, modality.column, modality.type, event.type,
  across.event.type, prop.test = NULL, prop.adj = NULL)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{AssignModality} function.}

\item{modality.column}{Character string. Can take the value \code{"modality"}, \code{"modality.var"} or \code{"modality.bimodal.adj"}. Please refer to \code{AssignModality} function help page for more details.}

\item{modality.type}{Character string. \code{basic} indicates that only the main modalities (included, excluded, bimodal, middle, multimodal) are analysed. Sub-modalities (primary and dispersed) will be merged. \code{extended} indicates that both main and sub-modalities are analysed. Sub-modalities will not be merged.}

\item{event.type}{Character string. To indicate which event type to analyse. Can take the value \code{"SE"}, \code{"MXE"}, \code{"RI"}, \code{"A5SS"} or \code{"A3SS"}. Specify \code{"all"} to include all event types.}

\item{across.event.type}{Logical. If set to \code{TRUE}, the proportion of modality will be compared across the specified event types}

\item{prop.test}{Character string. Only applicable when \code{across.event.type} set to \code{TRUE}. \code{chisq} Chi-squared test used to compare the proportion of modalities across the different event splicing type. \code{fisher} Fisher test used to compare the proportion of modalities across the different splicing event type.}

\item{prop.adj}{Character string. Only applicable when \code{across.event.type} set to \code{TRUE}. Adjust p-values generated from \code{prop.test} for multiple testing. Options available as per \code{p.adjust} function.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot. If \code{across.event.type} set to \code{FALSE}, results returned to \code{$Modality$Prop$DoughnutChart} slot. If \code{across.event.type} set to \code{TRUE}, results returned to \code{$Modality$Prop$BarChart} slot.
}
\description{
\code{PropModality} tabulates and plots the proportion of each modality.
}
\details{
This function tabulates and plots the proportion of each modality for a specified splicing event type(s) or compares proportion of each modality across specified splicing event types.
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
