% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_05_EVENTS_EXPRESSED.R
\name{CountEvents}
\alias{CountEvents}
\title{Tabulate the number of expressed splicing events}
\usage{
CountEvents(MarvelObject, sample.ids, min.cells, event.group.colors = NULL)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{TransformExpValues} function.}

\item{sample.ids}{Vector of character strings. Sample IDs that constitute the cell group.}

\item{min.cells}{Numeric value. Minimum number of cells expressing the splicing event for the event to be included for tabulation. A splicing event is defined as expressed when it has a non-missing PSI value.}

\item{event.group.colors}{Vector of character strings. Colors for the event groups. If not specified, default \code{ggplot2} colors will be used.}
}
\value{
An object of class S3 with new slots \code{MarvelObject$N.Events$Table} and \code{MarvelObject$N.Events$Plot}.
}
\description{
Tabulates and plots the number of expressed splicing events for each splicing event category for a specified cell group.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

# Define cell group for analysis
df.pheno <- marvel.demo$SplicePheno
sample.ids <- df.pheno[which(df.pheno$cell.type=="iPSC"), "sample.id"]

# Tabulate expressed events
marvel.demo <- CountEvents(MarvelObject=marvel.demo,
                           sample.ids=sample.ids,
                           min.cells=5,
                           event.group.colors=NULL
                           )

# Check outputs
marvel.demo$N.Events$Table
marvel.demo$N.Events$Plot
}
