% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComDim.R
\name{ComDim}
\alias{ComDim}
\title{Common Dimensions analysis (ComDim)}
\usage{
ComDim(
  X,
  block,
  name.block,
  ncomp = NULL,
  scale = TRUE,
  scale.block = TRUE,
  threshold = 1e-08
)
}
\arguments{
\item{X}{Dataset obtained by horizontally merging all the blocks of variables.}

\item{block}{Vector indicating the number of variables in each block.}

\item{name.block}{names of the blocks of variables (NULL by default).}

\item{ncomp}{Number of dimensions to compute. By default (NULL), all the global components are extracted.}

\item{scale}{Logical, if TRUE (by default) then variables are scaled to unit variance (all variables are centered anyway).}

\item{scale.block}{Logical, if TRUE (by default) each block of variables is divided by the square root of its inertia (Frobenius norm).}

\item{threshold}{Convergence threshold}
}
\value{
Returns a list of the following elements:\cr

\item{optimalcrit}{Numeric vector of the optimal value of the criterion (sum of squared saliences) obtained for each dimension.}

\item{saliences}{Matrix of the specific weights of each block of variables on the global components, for each dimension.}

\item{T.g}{Matrix of normed global components.}

\item{Scor.g}{Matrix of global components (scores of individuals).}

\item{W.g}{Matrix of global weights (normed) associated with deflated X.}

\item{Load.g}{Matrix of global loadings (normed).}

\item{Proj.g}{Matrix of global projection (to compute scores from pretreated X).}

\item{explained.X}{Matrix of percentages of inertia explained in each block of variables.}

\item{cumexplained}{Matrix giving the percentages, and cumulative percentages, of total inertia of X blocks explained by the global components.}

\item{Block}{A list containing block components (T.b) and block weights (W.b)}
}
\description{
Performs ComDim analysis on a set of quantitative blocks of variables. ComDim can be viewed as a Multiblock Weighted Principal Components Analysis (MBWPCA)
}
\examples{
data(ham)
X=ham$X
block=ham$block
res.comdim <- ComDim(X,block,name.block=names(block))
summary(res.comdim)
plot(res.comdim)

}
\references{
E.M. Qannari, I. Wakeling, P. Courcoux, J.M. MacFie (2000). Defining the underlying sensory dimensions, Food Quality and Preference, 11: 151-154.\cr

E. Tchandao Mangamana, V. Cariou, E. Vigneau, R. Glèlè Kakaï, E.M. Qannari (2019). Unsupervised multiblock data analysis: A unified approach and extensions, Chemometrics and Intelligent Laboratory Systems, 194, 103856.
}
\seealso{
\code{\link{summary.ComDim}}    \code{\link{plot.ComDim}}
}
