% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.MBPLS.R
\name{coef.MBPLS}
\alias{coef.MBPLS}
\title{Regression coefficients of MBPLS models}
\usage{
\method{coef}{MBPLS}(object, ncomp = object$call$ncomp, ...)
}
\arguments{
\item{object}{An object resulting from \code{\link{MBPLS}}.}

\item{ncomp}{The number of components to be considered in the model. By default, all components computed in \code{\link{MBPLS}} or \code{\link{MBWCov}} are considered.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A matrix of regression coefficients where each row corresponds to a variable in X and each column corresponds to a variable in Y.
}
\description{
Computes regression coefficients from \code{\link{MBPLS}}.
}
\examples{
data(ham)
X=ham$X
block=ham$block
Y=ham$Y
res.mbpls <- MBPLS(X, Y, block, name.block = names(block))
coef(res.mbpls)

}
\seealso{
\code{\link{predict.MBPLS}}
}
