% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.functions.R
\name{plot.mb.predict}
\alias{plot.mb.predict}
\title{Plots predicted responses from a time-course MBNMA model}
\usage{
\method{plot}{mb.predict}(x, disp.obs = FALSE, overlay.ref = TRUE,
  col = "blue", max.col.scale = NULL, treat.labs = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{"mb.predict"} generated by
\code{predict("mbnma")}}

\item{disp.obs}{A boolean object to indicate whether to show shaded sections
of the plot for where there is observed data (\code{TRUE}) or not (\code{FALSE})}

\item{overlay.ref}{A boolean object indicating whether to overlay a line
showing the median network reference treatment response over time on the
plot (\code{TRUE}) or not (\code{FALSE}). The network reference treatment (treatment
\enumerate{
\item must be included in \code{predict} for this to display the network reference
treatment properly.
}}

\item{col}{A character indicating the colour to use for shading if \code{disp.obs}
is set to \code{TRUE}. Can be either \code{"blue"}, \code{"green"}, or \code{"red"}}

\item{max.col.scale}{Rarely requires adjustment. The maximum count of
observations (therefore the darkest shaded color) only used if \code{disp.obs} is
used. This allows consistency of shading between multiple plotted graphs.
It should always be at least as high as the maximum count of observations
plotted}

\item{treat.labs}{A vector of treatment labels in the same order as treatment codes.
Easiest to use treatment labels stored by \code{mb.network()}}

\item{...}{Arguments for \code{ggplot}}
}
\description{
Plots predicted responses from a time-course MBNMA model
}
\details{
For the S3 method \code{plot()}, if \code{disp.obs} is set to \code{TRUE} it is
advisable to ensure predictions in \code{predict} are estimated using an even
sequence of time points to avoid misrepresentation of shaded densities.
Shaded counts of observations will be relative to the treatment plotted in
each panel rather than to the network reference treatment if \code{disp.obs} is
set to \code{TRUE}.
}
\examples{
\donttest{
# Create an mb.network object from a dataset
network <- mb.network(alog_pcfb)

# Run an MBNMA model with an Emax time-course
emax <- mb.emax(network,
  emax=list(pool="rel", method="common"),
  et50=list(pool="rel", method="common"))

# Predict responses using the original dataset to estimate the network reference
#treatment response
df.ref <- alog_pcfb[alog_pcfb$treatment=="placebo",]
predict <- predict(emax, times=c(0:15), baseline=10, ref.estimate=df.ref)

# Plot the predicted responses with observations displayed on plot as green shading
plot(predict, disp.obs=TRUE, overlay.ref=FALSE, col="green")

# Plot the predicted responses with the median network reference treatment response overlayed
#on the plot
plot(predict, disp.obs=FALSE, overlay.ref=TRUE)
}

}
