\name{OTUsummary}
\alias{OTUsummary}
\title{
Summarizes and plots results of mcmc.otu() function series.
}
\description{
Calculates abundances of each OTU across factor combinations;
calculates pairwise differences between all factor combinations
and their significances for each OTU;
plots results as bar or line graphs with credible intervals (ggplot2)
NOTE: only works for experiments involving a single multi-level fixed factor
or two fully crossed multi-level fixed factors.
}
\usage{
OTUsummary(model, data, otus = NA, relative = FALSE, 
log.base = 10, summ.plot = TRUE, ptype = "z", xgroup=NULL, ...)
}
\arguments{
  \item{model}{
Model generated by mcmc.otu() or mcmc.otu.normalized() 
}
  \item{data}{
Dataset used to build the model (returned by otuStack() or otuStackNormalize())
}
  \item{otus}{
A vector of OTU names to summarize and plot. If left unspecified, all 
OTUs will be summarized.
}
  \item{relative}{
Whether to plot OTU abundances as log(proportion of total) (default) or fold-
changes relative to the sample that is considered to be "global control" 
(relative = TRUE). The "global control" is the combination of factors 
that served as a reference during model fitting, either because it is 
alphanumerically first (that happens by default) or because it has been 
explicitly designated as such using relevel() function. 
}
  \item{log.base}{
Base of the logarithm to use.
}
  \item{summ.plot}{
By default, the function generates a summary plot, which is a line-points-95\% 
credible intervals plot of log(fraction of total) with 'relative=FALSE' 
and a bar graph of log(fold change relative to the control), 
again with 95\%  credible intervals, with 'relative=TRUE'. Specify 
'summ.plot=FALSE' if you don't want the summary plot.
}
  \item{ptype}{
Which type of p-values to use. By default p-values based on the Bayesian 
z-score are used. Specify 'ptype="mcmc"' to output more conventional p-values 
based on MCMC sampling (these will be limited on the lower end by the size of 
MCMC sample).
}
  \item{xgroup}{
For two-factor designs: which of the factors to use to form the x-axis. The 
other one will be used to form facets.
}
  \item{\dots}{
Additional options for summaryPlotOTU() function. Among those, 'x.order' can be a 
vector specifying the order of factor levels on the x-axis.
}
}
\value{
A list of three items:
  \item{summary}{ Summary table containing calculated abundances, their SD 
  	and 95\% credible limits}
  \item{otuWise }{A series of matrices listing pairwise differences between 
  	factor combinations (upper triangle) and corresponding p-values (lower triangle)}
  \item{ggPlot }{the ggplot2 object for plotting. See http://docs.ggplot2.org/0.9.2.1/theme.html for ways 
to modify it, such as add text, rotate labels, change fonts, etc. }
}
\references{
Elizabeth A. Green, Sarah W. Davies, Mikhail V. Matz, Monica Medina Next-generation sequencing reveals cryptic Symbiodinium diversity within Orbicella faveolata and Orbicella franksi at the Flower Garden Banks, Gulf of Mexico. PeerJ 2014 https://peerj.com/preprints/246/ 
}
\author{
Mikhail V. Matz, University of Texas at Austin
<matz@utexas.edu>
}
\seealso{
mcmc.otu(),MCMCglmm()
}
\examples{

# see example in ?MCMC.OTU

}
