% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scythe.R
\name{write.Scythe}
\alias{write.Scythe}
\title{Write a Matrix to a File to be Read by Scythe}
\usage{
write.Scythe(outmatrix, outfile = NA, overwrite = FALSE)
}
\arguments{
\item{outmatrix}{The matrix to be written to a file.}

\item{outfile}{The file to be written. This can include path information.}

\item{overwrite}{A logical that determines whether an existing file should
be over-written.  By default, it protects the user from over-writing
existing files.}
}
\value{
A zero if the file is properly written.
}
\description{
This function writes a matrix to an ASCII file that can be read by the
Sycthe Statistical Library.  Scythe requires that input files contain the
number of rows and columns in the first row, followed by the data.
}
\examples{

  \dontrun{
  write.Scythe(mymatrix, "myfile.txt")
  }

}
\references{
Daniel Pemstein, Kevin M. Quinn, and Andrew D. Martin.  2007.
\emph{Scythe Statistical Library 1.0.} \url{http://scythe.wustl.edu}.
}
\seealso{
\code{\link{write.Scythe}}
}
\keyword{file}
