% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_k.R
\name{best.k}
\alias{best.k}
\title{Precision for the k Best-Performing Models}
\usage{
best.k(samples, k, ties.method = "min")
}
\arguments{
\item{samples}{a matrix with posterior samples (one per row) for the model posterior probabilities (one model per column). Can be estimated using \code{\link{stationary}} with the argument \code{summary = FALSE}.}

\item{k}{number of best-performing models to be considered}

\item{ties.method}{a character string specifying how ties are treated, see \code{\link[base]{rank}}}
}
\description{
Assesses the precision in estimating the ranking of the \eqn{k} best-performing models.
}
\examples{
# a sequence of uncorrelated model indices
mult <- rmultinom(1000, 1, c(.05, .6, .15, .12, .08))
idx <- apply(mult, 2, which.max)
z <- letters[idx]
stat <- stationary(z, summary = FALSE)
best.k(stat, 3)
}
