% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convertHMP2Binary}
\alias{convertHMP2Binary}
\title{Convert a HMDP model stored in a hmp (xml) file to binary file format.}
\usage{
convertHMP2Binary(file, prefix = "", getLog = TRUE)
}
\arguments{
\item{file}{The name of the HMP file (e.g. \code{r.hmp}).}

\item{prefix}{A character string with the prefix which will be added to the binary files.}

\item{getLog}{Output log text.}
}
\value{
NULL (invisible).
}
\description{
The function simply parse the hmp file and create binary files using
the \code{\link[=binaryMDPWriter]{binaryMDPWriter()}}.
}
\note{
Note all indexes are starting from zero (C/C++ style).
}
\examples{
## Set working dir
wd <- setwd(system.file("models", package = "MDP2"))

## Convert the machine example to a hmp file
prefix1 <- "machine1_"
getBinInfoStates(prefix1)
convertBinary2HMP(prefix1, duration = NULL)
# have a look at the hmp file
cat(readr::read_file("machine1_converted.hmp"))

## Convert the machine example hmp file to binary files
prefix2 <- "machine_cov_"
convertHMP2Binary("machine1.hmp", prefix2)
getBinInfoStates(prefix2)
## Convert the machine example with a single dummy node to a hmp file
#convertBinary2HMP("machine2_")  # error since using scope = 3 not supported in hmp files

## Reset working dir
setwd(wd)
}
\seealso{
\code{\link[=binaryMDPWriter]{binaryMDPWriter()}}.
}
