% (C) 2015 Christian Margreitter
% last update: 2017-02-21
\name{hbond}
\alias{hbond}
\title{Plot hydrogen bond summary}
\description{This function plots the summary output of hydrogen bond calculations and allows selection of donor and acceptor residues and atoms. Occurrence over the whole trajectory is indicated by a colour scale. A legend indicating the colour scale can be printed. Note, that in case multiple hydrogen bond interactions between two particular residues take place, the one with prevalence will be used for colour-coding (and by default, this interaction is marked with a black circle, see below).}
\usage{
hbond( hbonds,
       plotMethod = "residue-wise",
       acceptorRange = NA,
       donorRange = NA,
       printLegend = TRUE,
       showMultipleInteractions = TRUE,
       barePlot = FALSE,
       ... )}
\arguments{
  \item{hbonds}{Table containing the hydrogen bond information in its columns \code{hbondID}, \code{resDonor}, \code{resDonorName}, \code{resAcceptor}, \code{resAcceptorName}, \code{atomDonor}, \code{atomDonorName}, \code{atomH}, \code{atomAcceptor}, \code{AtomAcceptorName}, \code{percentage}. This kind of table is automatically generated by function \code{\link{load_hbond}()}.}
  \item{plotMethod}{Allows to set the detail of hbond information displayed. Options are currently:
                    \itemize{\item \code{residue-wise}}}
  \item{acceptorRange}{Vector, specifying which range of acceptor residues is used.}
  \item{donorRange}{Vector, specifying which range of donor residues is used.}
  \item{printLegend}{Boolean, used to print or hide the legend for the occurences.}
  \item{showMultipleInteractions}{If \code{TRUE}, this option causes multiple interactions between the same residues as being represented by a black circle around the coloured dot.}
  \item{barePlot}{Boolean, indicating whether the plot is to be made without any additional information.}
  \item{...}{Additional arguments (ellipsis).}
}
\value{
Returns a table containing the information used for the plot:
\itemize{\item{\code{resDonor}} Residue number (donor).
\item{\code{resAcceptor}} Residue number (acceptor).
\item{\code{percentage}} Percentage, that has been used for colour-coding.
\item{\code{numberInteractions}} Number of hydrogen bond interactions taking place between the specified donor and acceptor residues.
}}
\examples{
# GROMOS (see load_hbond() for other input possibilities)
hbond( load_hbond( system.file( "extdata/hbond_example.txt.gz",
                                package = "MDplot" ) ) )
}
\author{Christian Margreitter}
\keyword{hbond}
\keyword{hydrogen bond}