% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mvad}
\alias{mvad}
\title{MVAD: Transition from school to work}
\format{
A data frame containing 712 rows, 72 state variables, 1 id variable and 13 covariates.
}
\source{
McVicar and Anyadike-Danes (2002)
}
\usage{
data(mvad)
}
\description{
The data comes from a study by McVicar and Anyadike-Danes on transition from school to work. The data consist of static background characteristics and a time series sequence of 72 monthly labour market activities for each of a cohort of 712 individuals in the Status Zero Survey. The individuals were followed up from July 1993 to June 1999. The monthly states are recorded in columns 15 (\code{Jul.93}) to 86 (\code{Jun.99}).
}
\details{
States are:\cr

\tabular{ll}{
 \code{employment}  \tab (EM) \cr
 \code{FE}          \tab further education (FE) \cr
 \code{HE}          \tab higher education (HE) \cr
 \code{joblessness} \tab (JL) \cr
 \code{school}      \tab (SC) \cr
 \code{training}    \tab (TR) \cr
}
The data set contains also ids (\code{id}) and sample weights (\code{weights}) as well as the following binary covariates:\cr
\cr
\code{male}\cr
\code{catholic}\cr
\code{Belfast}, \code{N.Eastern}, \code{Southern}, \code{S.Eastern}, \code{Western} (location of school, one of five Education and Library Board areas in Northern Ireland)\cr
\code{Grammar} (type of secondary education, 1=grammar school)\cr
\code{funemp} (father's employment status at time of survey, 1=father unemployed)\cr
\code{gcse5eq} (qualifications gained by the end of compulsory education, 1=5+ GCSEs at grades A-C, or equivalent)\cr
\code{fmpr} (SOC code of father's current or most recent job at time of survey, 1=SOC1 (professional, managerial or related))\cr
\code{livboth} (living arrangements at time of first sweep of survey (June 1995), 1=living with both parents)
}
\note{
The first two months of the observation period coincide with summer holidays from school. Hence, documented examples throughout this package extract only the states in columns 17 to 86; i.e. sequences of length 70 from \code{Sep.93} to \code{Jun.99}.
}
\examples{
data(mvad, package="MEDseq")

mvad$Location <- factor(apply(mvad[,5:9], 1L, function(x) 
                 which(x == "yes")), labels = colnames(mvad[,5:9]))
mvad          <- list(covariates = mvad[c(3:4,10:14,87)],
                      sequences = mvad[,15:86], 
                      weights = mvad[,2])
mvad.cov      <- mvad$covariates

# Create a state sequence object with the first two (summer) time points removed
states        <- c("EM", "FE", "HE", "JL", "SC", "TR")
labels        <- c("Employment", "Further Education", "Higher Education", 
                   "Joblessness", "School", "Training")
mvad.seq      <- seqdef(mvad$sequences[-c(1,2)], states=states, 
                        labels=labels, weights=mvad$weights)
}
\references{
McVicar, D. (2000). Status 0 four years on: young people and social exclusion in Northern Ireland. \emph{Labour Market Bulletin}, 14, 114-119.

McVicar, D. and Anyadike-Danes, M. (2002). Predicting successful and unsuccessful transitions from school to work by using sequence methods. \emph{Journal of the Royal Statistical Society: Series A (Statistics in Society)}, 165(2): 317-334.
}
\keyword{datasets}
