% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lower.tri.vector.R
\name{lower.tri.vector}
\alias{lower.tri.vector}
\title{Split Matrix by Clusters and Return Lower Triangular Parts as Vector}
\usage{
lower.tri.vector(x, cluster = rep(1, nrow(x)), diag = FALSE)
}
\arguments{
\item{x}{a square matrix}

\item{cluster}{numeric or factor. Is used to identify the sub-matrices of
\code{x} from which the lower triangular parts are extracted. Defaults to
the full matrix.}

\item{diag}{logical. Should the diagonal be included?}
}
\value{
Returns a numeric vector containing the elements of the lower
triangular sub matrices.
}
\description{
Split a matrix into block diagonal sub matrices according to clusters and
combine the lower triangular parts into a vector
}
\examples{

m <- matrix(1:64, ncol=8)
cluster <- c(1, 1, 1, 1, 2, 2, 3, 3)
lower.tri.vector(m, cluster)

}
\seealso{
\code{\link{lower.tri}}
}
\author{
Claus Ekstrom \email{claus@ekstroem.dk}
}
\keyword{manip}
