% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kfilter.R
\name{Kfilter_fused}
\alias{Kfilter_fused}
\title{The fused kolmogorov filter: a nonparametric model-free screening method}
\usage{
Kfilter_fused(X, Y, nsis = (dim(X)[1])/log(dim(X)[1]))
}
\arguments{
\item{X}{The design matrix of dimensions n * p. Each row is an observation vector.}

\item{Y}{The response vector of dimension n * 1.}

\item{nsis}{Number of predictors recruited by Kfilter_fused. The default is n/log(n).}
}
\value{
the labels of first nsis largest active set of all predictors
}
\description{
The fused kolmogorov filter: a nonparametric model-free screening method
}
\examples{
##Scenario 1  generate discrete response data
n=100;
p=200;
R=5;
data=GendataLDA(n,p,R,error="gaussian",style="balanced")
data=cbind(data[[1]],data[[2]])
colnames(data)[1:ncol(data)]=c(paste0("X",1:(ncol(data)-1)),"Y")
data=as.matrix(data)
X=data[,1:(ncol(data)-1)];
Y=data[,ncol(data)];
A1=Kfilter_fused(X,Y,n/log(n));A1

##Scenario 2  generate continuous response data
n=100;
p=200;
rho=0.5;
data=GendataLM(n,p,rho,error="gaussian")
data=cbind(data[[1]],data[[2]])
colnames(data)[1:ncol(data)]=c(paste0("X",1:(ncol(data)-1)),"Y")
data=as.matrix(data)
X=data[,1:(ncol(data)-1)];
Y=data[,ncol(data)];
A2=Kfilter_fused(X,Y,n/log(n));A2

}
\references{
Mai, Q., & Zou, H. (2015). The fused Kolmogorov filter: A nonparametric model-free screening method. The Annals of Statistics, 43(4), 1471-1497.
}
