% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFT.m_est.R
\name{MFT.m_est}
\alias{MFT.m_est}
\title{MFT.m_est}
\usage{
MFT.m_est(Phi, n = 200, maxlag = 10, plot = TRUE)
}
\arguments{
\item{Phi}{spike train, vector of time stamps}

\item{n}{positive integer, number of life times used in segments for estimation of serial correlation}

\item{maxlag}{non-negative integer, maximal lag up to which serial correlations are calculated}

\item{plot}{logical, if TRUE, estimation procedure is plotted}
}
\value{
\item{m_est}{non-negative integer, estimated order of serial correlation (m-dependence)}
}
\description{
Naive routine for the estimation of the order of serial correlation (m-dependence) in point processes.
}
\examples{
# 1. Homogeneuous Poisson process (m = 0)
Phi <- cumsum(rexp(2000,rate=5)) 
MFT.m_est(Phi)

# 2. Point process simulated according to model
# X_i = a_0 X_i + a_1 X_{i-1} + ... a_m X_{i-m}
# with life times X_i gamma-distributed and true m = 3.
m   <- 3
Tt  <- 300
# generate coefficients a_i
c   <- 0.5
aa  <- c(1,c); for (i in 2:11) aa[i] <- c*aa[i-1]
a   <- aa[1:(m+1)]
# build auxiliary processes
muX1 <- 0.05/(sum(a)); muX2 <- 0.1/(sum(a)); muX3 <- 0.2/(sum(a))
sigmaX <- sqrt(0.0225/(sum(a^2)))
shape1 <- muX1^2/sigmaX^2;rate1 <- muX1/sigmaX^2
shape2 <- muX2^2/sigmaX^2;rate2 <- muX2/sigmaX^2
shape3 <- muX3^2/sigmaX^2;rate3 <- muX3/sigmaX^2
len  <- 10000
X1   <- rgamma(10000,rate=rate1,shape=shape1); M1 <- embed(X1,m+1)
Phi1 <- cumsum(as.vector(M1 \%*\% a)); Phi1 <- Phi1[Phi1<Tt]
X2   <- rgamma(10000,rate=rate2,shape=shape2); M2 <- embed(X2,m+1)
Phi2 <- cumsum(as.vector(M2 \%*\% a)); Phi2 <- Phi2[Phi2<Tt]
X3   <- rgamma(10000,rate=rate3,shape=shape3); M3 <- embed(X3,m+1)
Phi3 <- cumsum(as.vector(M3 \%*\% a)); Phi3 <- Phi3[Phi3<Tt]
# build final point process
Phi  <- sort(c(Phi1[Phi1<Tt/3],Phi2[Phi2>Tt/3 & Phi2<(2/3)*Tt],Phi3[Phi3>(2/3)*Tt]))
# estimate m
MFT.m_est(Phi)

}
\references{
Michael Messer, Kaue M. Costa, Jochen Roeper and Gaby Schneider (2017).
Multi-scale detection of rate changes in spike trains with weak dependencies. Journal of Computational Neuroscience, 42 (2), 187-201.
<doi:10.1007/s10827-016-0635-3>
}
\seealso{
\code{\link{MFT.rate}, \link{MFT.variance}, \link{MFT.mean}}
}
\author{
Michael Messer, Stefan Albert, Solveig Plomer and Gaby Schneider
}
