% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGDrivE-Releases.R
\name{basicRepeatedReleases}
\alias{basicRepeatedReleases}
\title{Make List of Modified Mosquito Releases}
\usage{
basicRepeatedReleases(genotypes, releaseStart, releaseEnd, releaseInterval,
  releaseVector, sex = "M")
}
\arguments{
\item{genotypes}{possible genotypes}

\item{releaseStart}{day releases start}

\item{releaseEnd}{day releases end}

\item{releaseInterval}{interval between releases}

\item{releaseVector}{named character vector of release composition}

\item{sex}{character in 'M','F','E'}
}
\description{
Sets up a release schedule for a single patch, returns a list to be used in
\code{\link{oneDay_maleReleases_Patch}} or \code{\link{oneDay_femaleReleases_Patch}}.
}
\examples{
# to setup for 3 patches but only release in the first with a defined release schedule:

patchReleases = replicate(n = 3,expr = {
  list(maleReleases = NULL,femaleReleases = NULL)
},simplify = FALSE)

patchReleases[[1]]$femaleReleases = basicRepeatedReleases(genotypes = cubeHoming1RA$genotypesID,
                                                          releaseStart = 5,
                                                          releaseEnd = 30,
                                                          releaseInterval = 5,
                                                          releaseVector = c("HH"=100,
                                                                            "Hh"=0,
                                                                            "HR"=0,
                                                                            "hh"=0,
                                                                            "hR"=0,
                                                                            "RR"=0),
                                                          sex = "F")
patchReleases[[1]]$maleReleases = basicRepeatedReleases(genotypes = cubeHoming1RA$genotypesID,
                                                        releaseStart = 50,
                                                        releaseEnd = 60,
                                                        releaseInterval = 1,
                                                        releaseVector = c("HH"=100,
                                                                          "Hh"=0,
                                                                          "HR"=0,
                                                                          "hh"=0,
                                                                          "hR"=0,
                                                                          "RR"=0),
                                                        sex = "M")

}
