% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calcLognormalKernel}
\alias{calcLognormalKernel}
\title{Calculate Lognormal Stochastic Matrix}
\usage{
calcLognormalKernel(distMat, meanlog, sdlog)
}
\arguments{
\item{distMat}{distance matrix from \code{\link[MGDrivE]{calcVinEll}}}

\item{meanlog}{log mean of \code{\link[stats]{Lognormal}} distribution}

\item{sdlog}{log standard deviation of \code{\link[stats]{Lognormal}} distribution}
}
\description{
Given a distance matrix from \code{\link[MGDrivE]{calcVinEll}},
calculate a stochastic matrix where one step movement probabilities follow a lognormal density.
}
\examples{
# setup distance matrix
# two-column matrix with latitude/longitude, in degrees
latLong = cbind(runif(n = 5, min = 0, max = 90),
                runif(n = 5, min = 0, max = 180))

# Vincenty Ellipsoid  distance formula
distMat = calcVinEll(latLongs = latLong)

# calculate lognormal distribution over distances
#  mean and standard deviation are just for example
kernMat = calcLognormalKernel(distMat = distMat, meanlog = 100, sdlog = 10)

}
