% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equilibrium-auxiliary.R
\name{solve_muAqua}
\alias{solve_muAqua}
\title{Solve for Constant Aquatic Mortality}
\usage{
solve_muAqua(params, rm)
}
\arguments{
\item{params}{a named list of parameters}

\item{rm}{the daily growth rate}
}
\value{
location of the root, as provided from uniroot
}
\description{
In \code{MGDrivE}, the model was typically solved at equilibrium assuming the
density-independent mortality was constant over aquatic stages (eggs, larvae, pupae),
given a daily growth rate, \eqn{r_{M}}. Given that growth rate, it solved for
that mortality \eqn{\mu_{Aqua}} by relating it with \eqn{R_{M}}, the per-generation
growth rate of the population, calculable from \eqn{r_{M}} and the mean
duration of life stages. This function uses \code{\link[stats]{uniroot}} to
solve for \eqn{mu_{Aqua}}.
}
\details{
This function needs the following parameters in \code{params}:
\itemize{
\item \code{muF}: adult female mortality
\item \code{beta}: rate of egg laying
\item \code{phi}: sex ratio at emergence
\item \code{qE}: inverse of mean duration of egg stage
\item \code{nE}: shape parameter of Erlang-distributed egg stage
\item \code{qL}: inverse of mean duration of larval stage
\item \code{nL}: shape parameter of Erlang-distributed larval stage
\item \code{qP}: inverse of mean duration of pupal stage
\item \code{nP}: shape parameter of Erlang-distributed pupal stage
}
}
\examples{
theta <- list(qE = 1/4, nE = 2, qL = 1/5, nL = 3, qP = 1/6, nP = 2, muF = 1/12,
             beta = 32, phi = 0.5);
muAqatic <- solve_muAqua(params = theta, rm = 1.096)

}
