% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FWERSU.R
\name{Roth.rej}
\alias{Roth.rej}
\title{The number of rejected hypotheses for Roth's step-up FWER controlling procedure.}
\usage{
Roth.rej(p,p.set,alpha)
}
\arguments{
\item{p}{numeric vector of p-values (possibly with \code{\link[base]{NA}}s). Any other R is coerced by \code{\link[base]{as.numeric}}. Same as in \code{\link[stats]{p.adjust}}.}

\item{p.set}{a list of numeric vectors, where each vector is the vector of all attainable p-values containing the available p-value for the corresponding hypothesis..}

\item{alpha}{the given significant level for Roth's procedure, the default value is 0.05.}
}
\value{
An integer value of the number of rejected hypotheses.
}
\description{
The function for calculating the number of rejected hypotheses (rejection region) based on original available p-values, all attaianble p-values and the given significant level.
}
\examples{
p <- c(pbinom(1,8,0.5),pbinom(1,5,0.75),pbinom(1,6,0.6))
p.set <-list(pbinom(0:8,8,0.5),pbinom(0:5,5,0.75),pbinom(0:6,6,0.6))
Roth.rej(p,p.set,0.05)
}
\author{
Yalin Zhu
}
\references{
Roth, A. J. (1999).
Multiple comparison procedures for discrete test statistics.
\emph{Journal of statistical planning and inference}, \strong{82}: 101-117.

Hochberg, Y. (1988).
 A sharper Bonferroni procedure for multiple tests of significance.
 \emph{ Biometrika}, \strong{75}: 800-803.
}

