% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chooseModel.R
\name{chooseModel}
\alias{chooseModel}
\title{Trains a model containing the explanatory variables specified.}
\usage{
chooseModel(dvdata, formula, algorithm = "maxent")
}
\arguments{
\item{dvdata}{A list containing first the response variable, followed by data
frames of \emph{selected} derived variables for a given explanatory
variable (e.g. the first item in the list returned by
\code{\link{selectDVforEV}}).}

\item{formula}{A model formula (in the form y ~ x + ...) specifying the
independent terms (EVs) to be included in the model. The item in
\code{dvdata} is still taken as the response variable, regardless of
\code{formula}.}

\item{algorithm}{Character string matching either "maxent" or "LR", which
determines the type of model built. Default is "maxent".}
}
\description{
\code{chooseModel} trains a model based on the formula provided. The formula
specifies which explanatory variables (EVs) --- and potentially first-order
interactions between these --- should be included in the model. Each EV can
be represented by 1 or more derived variables (see \code{\link{deriveVars}}).
The function may be employed to choose a model from the selection pathway of
\code{\link{selectEV}} other than the model selected under the provided alpha
value.
}
\details{
Explanatory variables should be uniquely named. Underscores ('_') and colons
(':') are reserved to denote derived variables and interaction terms
respectively, and \code{chooseModel} will replace these --- along with other
special characters --- with periods ('.').
}
\examples{
\dontrun{
# From vignette:
grasslandmodel <- chooseModel(grasslandDVselect$dvdata,
                              formula("~ pr.bygall + geoberg + lcucor1 +
                                      tertpi09 + geolmja1"))
}

}
