% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_data.R
\name{mic_r_breakpoint}
\alias{mic_r_breakpoint}
\title{R breakpoint for MIC}
\usage{
mic_r_breakpoint(mo, ab, accept_ecoff = FALSE, ...)
}
\arguments{
\item{mo}{mo name (coerced using AMR::as.mo)}

\item{ab}{ab name (coerced using AMR::as.ab)}

\item{accept_ecoff}{if TRUE, ECOFFs will be used when no clinical breakpoints are available}

\item{...}{additional arguments to pass to AMR::as.sir, which is used to
calculate the R breakpoint}
}
\value{
MIC value
}
\description{
R breakpoint for MIC
}
\examples{
mic_r_breakpoint("B_ESCHR_COLI", "AMK")
mic_r_breakpoint("B_ESCHR_COLI", "CHL", accept_ecoff = TRUE)
}
