% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_calibration_curve}
\alias{plot_calibration_curve}
\title{Plotting Calibration Curve}
\usage{
plot_calibration_curve(analysis_object)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'fine_tuning()'.}
}
\value{
analysis_object
}
\description{
The \strong{plot_calibration_curve()} function is specifically designed for binary classification and produces
calibration curves that evaluate correspondence between predicted probabilities and observed frequencies.
This function is restricted to binary classification problems and provides crucial information about the
reliability of the model's probabilistic estimates.
}
\examples{
# Note: For obtaining the calibration curve plot the user needs to
# complete till fine_tuning( ) function of the MLwrap pipeline and
# only with binary outcome.

\donttest{

wrap_object <- preprocessing(df = sim_data,
                             formula = psych_well_bin ~ depression + emot_intel + resilience,
                             task = "classification")
wrap_object <- build_model(wrap_object, "Random Forest")
wrap_object <- fine_tuning(wrap_object, "Bayesian Optimization")

# And then, you can obtain the calibration curve plot.

plot_calibration_curve(wrap_object)

}

}
