% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParEst.R
\name{ParEst}
\alias{ParEst}
\title{Estimate theta and psi in multinomial mixture model}
\usage{
ParEst(data, d, k, TT = 1000)
}
\arguments{
\item{data}{- data in matrix formation with n rows and p columns}

\item{d}{- number of categories for each variable}

\item{k}{- number of components}

\item{TT}{- number of iterations in Gibbs sampler, default value is 1000. T should be an even number for 'burn-in'.}
}
\value{
theta - vector of probability for each component

psi - specific probability for each variable in each component
}
\description{
This function is used to estimate theta and psi in multinomial mixture model given the number of components k.
}
\examples{
# dimension parameters
n<-200; p<-5; d<-rep(2,p);
# generate complete data
Complete<-GenerateData(n, p, d, k = 3)
# mask percentage of data at MCAR
Incomplete<-Complete
Incomplete[sample(1:n*p,0.2*n*p,replace = FALSE)]<-NA
# k identify
K<-kIdentifier(data = Incomplete, d, TT = 10)
Par<-ParEst(data = Incomplete, d, k = K$k_est, TT = 10)
}
