% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSampleTileMatrix.R
\name{getSampleTileMatrix}
\alias{getSampleTileMatrix}
\title{\code{getSampleTileMatrix}}
\usage{
getSampleTileMatrix(
  tileResults,
  cellPopulations = "ALL",
  groupColumn = NULL,
  threshold = 0.2,
  log2Intensity = TRUE,
  numCores = 1,
  verbose = FALSE
)
}
\arguments{
\item{tileResults}{a MultiAssayExperiment returned by callOpenTiles
containing containing peak calling results.}

\item{cellPopulations}{vector of strings. Cell subsets in TileResults for
which to generate sample-tile matrices. This list of group names must be
identical to names that appear in the ArchRProject metadata.  If
cellPopulations='ALL', then peak calling is done on all cell populations in
the ArchR project metadata. Default is 'ALL'.}

\item{groupColumn}{Optional, the column containing sample group labels for
determining consensus tiles within sample groups. Default is NULL, all
samples will be used for determining consensus tiles.}

\item{threshold}{Threshold for consensus tiles, the minimum \% of samples
(within a sample group, if groupColumn is set) that a peak must be called
in to be retained. If set to 0, retain the union of all samples' peaks
(this is equivalent to a threshold of 1/numSamples). It is recommended to
tune this parameter to omit potentially spurious peaks.}

\item{log2Intensity}{Boolean, set to TRUE to return the log2 of the
sample-tile intensity matrix. Optional, default is FALSE.}

\item{numCores}{Optional, the number of cores to use with multiprocessing.
Default is 1.}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
SampleTileMatrices a MultiAssayExperiment containing a sample-tile
  intensity matrix for each cell population
}
\description{
\code{getSampleTileMatrix} takes the output of peak calling with
  callOpenTiles and creates sample-tile matrices containing the signal
  intensity at each tile.
}
\examples{
\donttest{
# Starting from GRangesList
if (
  require(BSgenome.Hsapiens.UCSC.hg19) && 
  require(TxDb.Hsapiens.UCSC.hg38.refGene) && 
  require(org.Hs.eg.db)
) {
tiles <- MOCHA::callOpenTiles(
  ATACFragments = MOCHA::exampleFragments,
  cellColData = MOCHA::exampleCellColData,
  blackList = MOCHA::exampleBlackList,
  genome = BSgenome.Hsapiens.UCSC.hg19,
  TxDb = TxDb.Hsapiens.UCSC.hg38.refGene,
  Org = org.Hs.eg.db,
  outDir = tempdir(),
  cellPopLabel = "Clusters",
  cellPopulations = c("C2", "C5"),
  numCores = 1
)

SampleTileMatrices <- MOCHA::getSampleTileMatrix(
  tiles,
  cellPopulations = c('C2', 'C5'),
  threshold = 0 # Take union of all samples' open tiles
)
}
}

}
