% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EarthdataLogin.R
\name{EarthdataLogin}
\alias{EarthdataLogin}
\title{Create File with Earthdata Login Credentials}
\usage{
EarthdataLogin(usr = NULL, pwd = NULL)
}
\arguments{
\item{usr, pwd}{Login credentials as \code{character}. If \code{NULL}, 
username and password are read from the terminal.}
}
\value{
The \code{\link{invisible}} Earthdata login credentials as \code{list}.
}
\description{
Create a hidden \code{.netrc} file with Earthdata login credentials in your 
home directory. The information included therein is used to login to 
\url{https://urs.earthdata.nasa.gov/} which is a mandatory requirement in 
order to download MODIS data from LP DAAC, LAADS and NSIDC (see also 
\code{\link{MODISoptions}}). If \code{.netrc} does exists the function can
be used to re-enter credentials.
}
\examples{
\dontrun{
EarthdataLogin()
}

}
\seealso{
\itemize{
\item{\url{https://docs.opendap.org/index.php/DAP_Clients_-_Authentication#LDAP} 
(section 2.2)}
\item{\url{https://github.com/MatMatt/MODIS/issues/10}}
\item{\url{https://wiki.earthdata.nasa.gov/display/EL/How+To+Access+Data+With+cURL+And+Wget}}
}
}
\author{
Matteo Mattiuzzi and Florian Detsch
}
