% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp_process.R
\name{MODIStsp_process}
\alias{MODIStsp_process}
\title{MODIStsp main processing function}
\usage{
MODIStsp_process(sel_prod, start_date, end_date, out_folder, out_folder_mod,
  reprocess = "Yes", delete_hdf = "No", sensor, download_server, user,
  password, https, start_x, start_y, end_x, end_y, full_ext, bbox, out_format,
  compress, out_res_sel, out_res, native_res, tiled, mod_proj_str, outproj_str,
  nodata_in, nodata_out, nodata_change, scale_val, scale_factor, offset,
  datatype, bandsel, bandnames, indexes_bandsel, indexes_bandnames,
  indexes_formula, indexes_nodata_out, quality_bandnames, quality_bandsel,
  quality_bitN, quality_source, quality_nodata_in, quality_nodata_out,
  file_prefixes, main_out_folder, resampling, ts_format, use_aria = TRUE,
  download_range = "full", gui = TRUE, n_retries, verbose)
}
\arguments{
\item{sel_prod}{\code{character} Name of selected MODIS product.}

\item{start_date}{\code{character} Start date for images download and preprocessing
(yyyy.mm.dd).}

\item{end_date}{\code{character} End date for images download and preprocessing
(yyyy.mm.dd).}

\item{out_folder}{\code{character} Main output folder.}

\item{out_folder_mod}{\code{character} Output folder for original HDF storage.}

\item{reprocess}{\code{character ["Yes" | "No"]} If Yes, reprocess data for already
existing dates.}

\item{delete_hdf}{\code{character ["Yes" | "No"]} If Yes, delete original HDF after
completion.}

\item{sensor}{\code{character ["Terra"| "Aqua" | "Both"]} MODIS platform to be considered.
(Ignored for MCD* products).}

\item{download_server}{\code{character ["http" | "offline"]} service to be used for
download.}

\item{user}{\code{character} Username for NASA http server.
(\href{https://urs.earthdata.nasa.gov/home}{urs.earthdata.nasa.gov/home}).}

\item{password}{\code{character} Password for NASA http server
(\href{https://urs.earthdata.nasa.gov/home}{urs.earthdata.nasa.gov/home}).}

\item{https}{\code{list} http addresses for download of HDF of selected product.}

\item{start_x}{\code{integer [0-35]} Start horizontal tile.}

\item{start_y}{\code{integer [0-17]} Start vertical tile.}

\item{end_x}{\code{integer [0-35]} End horizontal tile.}

\item{end_y}{\code{integer [0-17]} End vertical tile.}

\item{full_ext}{\code{characrter ["FullTiles" | "Resized"]} If "Full_Ext", process
the entire extent of the selected tiles. Otherwise, crop the output to
output bbox.}

\item{bbox}{\code{numeric(4)} Output bounding box (xmin, ymin, xmax, ymax) in
out_proj coordinate system.}

\item{out_format}{\code{character ["ENVI" | "GTiff"]} Desired output format.}

\item{compress}{\code{character ["None" | "PACKBITS" | "LZW" | "DEFLATE"]}
Compression method for GTiff outputs (Ignored if \code{out_format == ENVI})}

\item{out_res_sel}{\code{character ["Native" | "Resampled"]} Indicates if the native
resolution of the product or a user supplied one is to be used.}

\item{out_res}{\code{float} Output resolution (in output projection measurement
unit). Ignored if out_res_sel == "Native".}

\item{native_res}{\code{float} Native resolution of MODIS product to be processed.}

\item{tiled}{\code{integer [0 | 1]} 1 = tiled product; 0 = non-tiled product
(resolution 0.05 deg - latlong projection).}

\item{mod_proj_str}{\code{character} proj4 string of MODIS product native projection.}

\item{outproj_str}{\code{character} proj4 string of selected output projection.}

\item{nodata_in}{\code{numeric array} Original NoData values of original layers of
the selected MODIS product.}

\item{nodata_out}{\code{numeric array} Target NoData values of MODIS original layers
(Ignored if nodata_change == FALSE).}

\item{nodata_change}{\code{character ["Yes" | "No"]} if Yes, NoData are set to nodata_out
in output rasters.}

\item{scale_val}{\code{character ["Yes" | "No"]} If == "Yes", scale and offset are applied to
original MODIS layers, and Spectral Indexes are saved as floating point. If
== "No", no rescaling is done and Spectral Indexes are saved as integer, with a
10000 scaling factor.}

\item{scale_factor}{\code{numeric array} of length equal to the number of original
layers of the selected product, containing scale factors to be applied to each
original layer to convert it to "correct" measure units.}

\item{offset}{\code{numeric array} of length equal to the number of original
layers of the selected product, containing offsets to be applied to each
original layer to convert it to "correct" measure units.}

\item{datatype}{\code{character array} datatypes of original MODIS bands
(e.g., "INT2S").}

\item{bandsel}{\code{integer 0/1 array} of length equal to number of original
layers of the selected product set to 1 for bands to be processed.}

\item{bandnames}{\code{character array} Abbreviated Names of original layers of the
selected product (used to build output file names).}

\item{indexes_bandsel}{\code{integer 0/1 array} array of length equal to the number
of Spectral Indexes available for the product (standard + user-provided),
set to  1 for indexes to be processed.}

\item{indexes_bandnames}{\code{character array} Abbreviated Names of SIs available
for the selected product (used to build output file names of SIs).}

\item{indexes_formula}{\code{character array} formulas of SIs available for the
selected product (standard and custom).}

\item{indexes_nodata_out}{\code{numeric array} NoData values to be used for SIs}

\item{quality_bandnames}{\code{character array} Abbreviated Names of Quality
Indicators available for the selected product (used to build output file
names of QIs).}

\item{quality_bandsel}{\code{integer 0|1 array} array of length equal to number
of available QIs, set to  1 for indexes to be processed.}

\item{quality_bitN}{\code{character array} with length equal to the number QIs
available for the selected product. Each entry contains the position of the
bits corresponding to a QI (e.g., 0-1) in its "source" MODIS layer.}

\item{quality_source}{\code{character array} which connects each QI to its "source"
original MODIS layer (multiple QIs share the same "source", since they are
derived from different bits of the bit-encoded layer).}

\item{quality_nodata_in}{\code{integer} Always set to 255.}

\item{quality_nodata_out}{\code{integer} Always set to 255.}

\item{file_prefixes}{\code{character} output file prefix of selected product
(e.g., MOD13Q1). Used to build output filenames.}

\item{main_out_folder}{\code{character} Main folder for storage of MODIStsp
time series.}

\item{resampling}{\code{character ["near" | "bilinear" | "cubic" | "lanczos" | "mode"]}
Resampling method to be used by \code{gdalwarp}.}

\item{ts_format}{\code{character ["None" | "ENVI Meta Files" | "GDAL vrt files" | "ENVI and GDAL"]} Selected virtual time series format.}

\item{use_aria}{\code{logical} If TRUE, aria2c is used to accelerate download
(if available !).}

\item{download_range}{\code{character ["full" | "seasonal"]} If "full", all the
available images between the starting and the ending dates are downloaded;
If "seasonal", only the images included in the season are downloaded
(e.g: if the starting date is 2005-12-01 and the ending is 2010-02-31, only
the images of December, January and February from 2005 to 2010 - excluding
2005-01, 2005-02 and 2010-12 - are downloaded).}

\item{gui}{\code{logical} Indicates if processing was called starting from an
interactive environment or not. If FALSE, processing messages are sent to a
log file instead than to the console, and gWidgets messages are suppressed}

\item{n_retries}{\code{numeric} maximum number of retries on download functions.
In case any download function fails more than \code{n_retries} times consecutively,
MODIStsp_process will abort, Default: 20}

\item{verbose}{\code{logical} If FALSE, suppress processing messages, Default: TRUE}
}
\value{
The function is called for its side effects.
}
\description{
Main processing function of MODIStsp. Takes as input processing
parameters specified by the user using MODIStsp_GUI and saved in
MODIStsp_Previous.json (Interactive mode), or a user specified JSON file
(non-interactive mode) and performs all required processing.
}
\details{
After retrieving the input processing options, the function
\enumerate{
\item Accesses NASA http archive to determine the list of files to be
downloaded/processed (or, in case of offline processing, get the list
of already available hdf files present in \code{out_mod_folder});
\item Performs all required processing steps on each date (download,
reprojection, resize, mosaicing, Spectral Indexes and Quality indicators
computation);
\item Creates virtual files of the processed time series.
}

Reprojection and resize is dealt with by accessing gdal routines through the
\href{https://CRAN.R-project.org/package=gdalUtils}{gdalUtils}
package.
Extraction of bitfields from Quality layers is done though bitwise computation
Checks are done in order to not re-download already existing HDF images, and not
reprocess already processed dates (if the user did not specify that)
}
\note{
Thanks Tomislav Hengl and Babak Naimi, whose scripts made the starting point for
development of this function (\href{http://r-gis.net/?q=ModisDownload}{ModisDownload};
\href{http://spatial-analyst.net/wiki/index.php?title=Download_and_resampling_of_MODIS_images}{Download_and_resampling_of_MODIS_images})

License: GPL 3.0
}
\author{
Lorenzo Busetto, phD (2014-2017) \email{lbusett@gmail.com}

Luigi Ranghetti, phD (2015) \email{ranghetti.l@irea.cnr.it}
}
